/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.BasicCredentials;
import com.aliyun.emr.fs.s3.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.s3.auth.NoCredentialsException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.fs.s3.internal.s3.S3LoginHelper;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
public class SimpleS3CredentialsProvider
implements S3CredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.s3.auth.SimpleS3CredentialsProvider";
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String securityToken;

    public SimpleS3CredentialsProvider(URI uri, Configuration conf, S3CredentialsProvider.CredentialType type) throws IOException {
        this(AuthUtils.getAccessKeys(uri, conf, type));
    }

    @VisibleForTesting
    SimpleS3CredentialsProvider(S3LoginHelper.Login login) {
        this.accessKeyId = login.getUser();
        this.accessKeySecret = login.getPassword();
        this.securityToken = login.getToken();
    }

    @Override
    public S3Credentials getCredentials() {
        if (!StringUtils.isEmpty(this.accessKeyId) && !StringUtils.isEmpty(this.accessKeySecret)) {
            if (!StringUtils.isEmpty(this.securityToken)) {
                return new BasicSessionCredentials(this.accessKeyId, this.accessKeySecret, this.securityToken);
            }
            return new BasicCredentials(this.accessKeyId, this.accessKeySecret);
        }
        throw new NoCredentialsException("SimpleS3CredentialsProvider", "No credentials in the configuration");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

