/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.commit;

import com.aliyun.emr.fs.s3.commit.magic.JindoS3MagicCommitter;
import com.aliyun.emr.fs.s3.common.AbstractJindoShimsFileSystem;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoS3Committer
extends FileOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(JindoS3Committer.class);
    private final FileOutputCommitter wrapped;

    public JindoS3Committer(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        if (this.useMagicCommitter(outputPath, context.getConfiguration())) {
            this.wrapped = new JindoS3MagicCommitter(outputPath, context);
            LOG.info("Using JindoS3MagicCommitter as Job Committer.");
        } else {
            this.wrapped = new FileOutputCommitter(outputPath, context);
            LOG.info("Using FileOutputCommitter as Job Committer.");
        }
    }

    public JindoS3Committer(Path outputPath, JobContext context) throws IOException {
        super(outputPath, context);
        if (this.useMagicCommitter(outputPath, context.getConfiguration())) {
            this.wrapped = new JindoS3MagicCommitter(outputPath, context);
            LOG.info("Using JindoS3MagicCommitter as Job Committer.");
        } else {
            this.wrapped = new FileOutputCommitter(outputPath, context);
            LOG.info("Using FileOutputCommitter as Job Committer.");
        }
    }

    public void setupJob(JobContext jobContext) throws IOException {
        this.wrapped.setupJob(jobContext);
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        this.wrapped.abortJob(jobContext, state);
    }

    public void cleanupJob(JobContext jobContext) throws IOException {
        this.wrapped.cleanupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        this.wrapped.commitJob(jobContext);
    }

    public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.wrapped.setupTask(taskAttemptContext);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
        return this.wrapped.needsTaskCommit(taskAttemptContext);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext, Path taskAttemptPath) throws IOException {
        return this.wrapped.needsTaskCommit(taskAttemptContext, taskAttemptPath);
    }

    public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.wrapped.commitTask(taskAttemptContext);
    }

    public void commitTask(TaskAttemptContext taskAttemptContext, Path taskAttemptPath) throws IOException {
        this.wrapped.commitTask(taskAttemptContext, taskAttemptPath);
    }

    public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.wrapped.abortTask(taskAttemptContext);
    }

    public void abortTask(TaskAttemptContext taskAttemptContext, Path taskAttemptPath) throws IOException {
        this.wrapped.abortTask(taskAttemptContext, taskAttemptPath);
    }

    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        this.wrapped.recoverTask(taskContext);
    }

    public boolean isRecoverySupported() {
        return this.wrapped.isRecoverySupported();
    }

    public boolean isRecoverySupported(JobContext jobContext) throws IOException {
        return this.wrapped.isRecoverySupported(jobContext);
    }

    public boolean isCommitJobRepeatable(JobContext jobContext) throws IOException {
        return this.wrapped.isCommitJobRepeatable(jobContext);
    }

    public Path getWorkPath() throws IOException {
        return this.wrapped.getWorkPath();
    }

    private boolean useMagicCommitter(Path outputPath, Configuration conf) throws IOException {
        if (outputPath == null) {
            return false;
        }
        FileSystem fs = outputPath.getFileSystem(conf);
        if (fs instanceof AbstractJindoShimsFileSystem) {
            return ((AbstractJindoShimsFileSystem)fs).isMagicCommitEnabled();
        }
        return false;
    }
}

