/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.InodeStatus;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.s3.internal.s3native.S3FileStatus;
import com.aliyun.emr.fs.s3.internal.s3native.S3OpContext;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ListStatusOp {
    static final Logger LOG = LoggerFactory.getLogger(S3ListStatusOp.class);
    private final S3OpContext context;
    private final FileSystem fs;
    private final CredentialContext s3Context;

    public S3ListStatusOp(S3OpContext context, FileSystem fs, CredentialContext s3Context) {
        this.context = context;
        this.fs = fs;
        this.s3Context = s3Context;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return this.listStatus(f, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path f, boolean recursive, boolean skipDir, boolean isSummary) throws IOException {
        Table statusList = null;
        try {
            statusList = this.context.s3FileletSystem.listStatus(new JindoRequestPath(f.toString(), this.s3Context), recursive, isSummary);
            ArrayList<S3FileStatus> fileStatuses = new ArrayList<S3FileStatus>();
            for (int i = 0; i < ((FileletStatusList)statusList).filesLength(); ++i) {
                InodeStatus inodeStatus = ((FileletStatusList)statusList).files(i).inodeAsInodeStatus();
                LOG.debug("path " + inodeStatus.fileName());
                if (inodeStatus.fileName().endsWith("_$folder$") || skipDir && 0 == inodeStatus.fileType()) continue;
                S3FileStatus fileStatus = new S3FileStatus(((FileletStatusList)statusList).files(i), this.fs.getConf());
                fileStatuses.add(fileStatus);
            }
            FileStatus[] fileStatusArray = fileStatuses.toArray(new FileStatus[0]);
            return fileStatusArray;
        }
        finally {
            if (statusList != null) {
                JbootBufferFactory.returnBuffer(statusList.getByteBuffer());
            }
        }
    }
}

