/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.FsCommandProvider;
import org.apache.hadoop.fs.shell.JindoFsCommandShims;
import org.apache.hadoop.fs.shell.PathData;

public class JfsRename
implements FsCommandProvider {
    @Override
    public Class<? extends FsCommand> getCommandClass() {
        return Rename.class;
    }

    public static class Rename
    extends CommandWithDestination {
        boolean isJfsRename = false;
        public static final String NAME = "mv";
        public static final String USAGE = "<src> ... <dst>";
        public static final String DESCRIPTION = "Move files that match the specified file pattern <src> to a destination <dst>.  When moving multiple files, the destination must be a directory.";

        public static void registerCommands(CommandFactory factory) {
            factory.addClass(Rename.class, new String[]{"-mv"});
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
            this.getRemoteDestination(args);
            this.isJfsRename = JindoFsCommandShims.isJfsBlockMode(this.dst.fs);
        }

        protected void processPath(PathData src, PathData target) throws IOException {
            String dstUri;
            String srcUri = src.fs.getUri().getScheme() + "://" + src.fs.getUri().getHost();
            if (!srcUri.equals(dstUri = target.fs.getUri().getScheme() + "://" + target.fs.getUri().getHost())) {
                throw new PathIOException(src.toString(), "Does not match target filesystem");
            }
            if (!this.isJfsRename && target.exists || this.isJfsRename && target.stat != null && !target.stat.isDirectory() && target.exists) {
                throw new PathExistsException(target.toString());
            }
            if (!target.fs.rename(src.path, target.path)) {
                throw new PathIOException(src.toString());
            }
        }

        protected PathData getTargetPath(PathData src) throws IOException {
            if (this.isJfsRename) {
                return this.dst;
            }
            return super.getTargetPath(src);
        }

        protected List<PathData> expandArgument(String oarg) throws IOException {
            if (this.isJfsRename) {
                boolean tailingWithStar = false;
                String commonName = "";
                String arg = oarg;
                if (arg.endsWith("*")) {
                    tailingWithStar = true;
                    Path path = new Path(arg);
                    arg = path.getParent().toString();
                    commonName = path.getName();
                }
                if (tailingWithStar && commonName.indexOf("*") == commonName.lastIndexOf("*")) {
                    PathData[] items = PathData.expandAsGlob((String)arg, (Configuration)this.getConf());
                    if (items.length == 0) {
                        throw new PathNotFoundException(arg);
                    }
                    ArrayList<PathData> ret = new ArrayList<PathData>(items.length);
                    for (PathData pd : items) {
                        PathData npd = new PathData(new Path(pd.path, commonName).toString(), this.getConf());
                        npd.exists = true;
                        npd.stat = new FileStatus();
                        ret.add(npd);
                    }
                    return ret;
                }
            }
            return super.expandArgument(oarg);
        }
    }
}

