/*
 * Decompiled with CFR 0.152.
 */
package bigboot.protocol.type;

import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DirectoryStatistics
extends Table {
    public static DirectoryStatistics getRootAsDirectoryStatistics(ByteBuffer _bb) {
        return DirectoryStatistics.getRootAsDirectoryStatistics(_bb, new DirectoryStatistics());
    }

    public static DirectoryStatistics getRootAsDirectoryStatistics(ByteBuffer _bb, DirectoryStatistics obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public DirectoryStatistics __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long dirNum() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateDirNum(long dirNum) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, dirNum);
            return true;
        }
        return false;
    }

    public long fileNum() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateFileNum(long fileNum) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, fileNum);
            return true;
        }
        return false;
    }

    public long size() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateSize(long size) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, size);
            return true;
        }
        return false;
    }

    public String hotness() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer hotnessAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer hotnessInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public long lastUpdate() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateLastUpdate(long lastUpdate) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, lastUpdate);
            return true;
        }
        return false;
    }

    public static int createDirectoryStatistics(FlatBufferBuilder builder, long dirNum, long fileNum, long size, int hotnessOffset, long lastUpdate) {
        builder.startObject(5);
        DirectoryStatistics.addLastUpdate(builder, lastUpdate);
        DirectoryStatistics.addSize(builder, size);
        DirectoryStatistics.addFileNum(builder, fileNum);
        DirectoryStatistics.addDirNum(builder, dirNum);
        DirectoryStatistics.addHotness(builder, hotnessOffset);
        return DirectoryStatistics.endDirectoryStatistics(builder);
    }

    public static void startDirectoryStatistics(FlatBufferBuilder builder) {
        builder.startObject(5);
    }

    public static void addDirNum(FlatBufferBuilder builder, long dirNum) {
        builder.addLong(0, dirNum, 0L);
    }

    public static void addFileNum(FlatBufferBuilder builder, long fileNum) {
        builder.addLong(1, fileNum, 0L);
    }

    public static void addSize(FlatBufferBuilder builder, long size) {
        builder.addLong(2, size, 0L);
    }

    public static void addHotness(FlatBufferBuilder builder, int hotnessOffset) {
        builder.addOffset(3, hotnessOffset, 0);
    }

    public static void addLastUpdate(FlatBufferBuilder builder, long lastUpdate) {
        builder.addLong(4, lastUpdate, 0L);
    }

    public static int endDirectoryStatistics(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

