/*
 * Decompiled with CFR 0.152.
 */
package bigboot.protocol.type;

import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class FileDiffData
extends Table {
    public static FileDiffData getRootAsFileDiffData(ByteBuffer _bb) {
        return FileDiffData.getRootAsFileDiffData(_bb, new FileDiffData());
    }

    public static FileDiffData getRootAsFileDiffData(ByteBuffer _bb, FileDiffData obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public FileDiffData __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int snapshotId() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateSnapshotId(int snapshotId) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, snapshotId);
            return true;
        }
        return false;
    }

    public String snapshotInodeId() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer snapshotInodeIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer snapshotInodeIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public int posteriorDiff() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutatePosteriorDiff(int posteriorDiff) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, posteriorDiff);
            return true;
        }
        return false;
    }

    public long fileSize() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateFileSize(long fileSize) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, fileSize);
            return true;
        }
        return false;
    }

    public String blockIds(int j) {
        int o = this.__offset(12);
        return o != 0 ? this.__string(this.__vector(o) + j * 4) : null;
    }

    public int blockIdsLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public static int createFileDiffData(FlatBufferBuilder builder, int snapshotId, int snapshotInodeIdOffset, int posteriorDiff, long fileSize, int blockIdsOffset) {
        builder.startObject(5);
        FileDiffData.addFileSize(builder, fileSize);
        FileDiffData.addBlockIds(builder, blockIdsOffset);
        FileDiffData.addPosteriorDiff(builder, posteriorDiff);
        FileDiffData.addSnapshotInodeId(builder, snapshotInodeIdOffset);
        FileDiffData.addSnapshotId(builder, snapshotId);
        return FileDiffData.endFileDiffData(builder);
    }

    public static void startFileDiffData(FlatBufferBuilder builder) {
        builder.startObject(5);
    }

    public static void addSnapshotId(FlatBufferBuilder builder, int snapshotId) {
        builder.addInt(0, snapshotId, 0);
    }

    public static void addSnapshotInodeId(FlatBufferBuilder builder, int snapshotInodeIdOffset) {
        builder.addOffset(1, snapshotInodeIdOffset, 0);
    }

    public static void addPosteriorDiff(FlatBufferBuilder builder, int posteriorDiff) {
        builder.addInt(2, posteriorDiff, 0);
    }

    public static void addFileSize(FlatBufferBuilder builder, long fileSize) {
        builder.addLong(3, fileSize, 0L);
    }

    public static void addBlockIds(FlatBufferBuilder builder, int blockIdsOffset) {
        builder.addOffset(4, blockIdsOffset, 0);
    }

    public static int createBlockIdsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startBlockIdsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endFileDiffData(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

