/*
 * Decompiled with CFR 0.152.
 */
package bigboot.protocol.type;

import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class HdfsBlockLocation
extends Table {
    public static HdfsBlockLocation getRootAsHdfsBlockLocation(ByteBuffer _bb) {
        return HdfsBlockLocation.getRootAsHdfsBlockLocation(_bb, new HdfsBlockLocation());
    }

    public static HdfsBlockLocation getRootAsHdfsBlockLocation(ByteBuffer _bb, HdfsBlockLocation obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public HdfsBlockLocation __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String ipAddr() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer ipAddrAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer ipAddrInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public int port() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutatePort(int port) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, port);
            return true;
        }
        return false;
    }

    public String datanodeuuid() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer datanodeuuidAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer datanodeuuidInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public String storageId() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer storageIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer storageIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public static int createHdfsBlockLocation(FlatBufferBuilder builder, int ipAddrOffset, int port, int datanodeuuidOffset, int storageIdOffset) {
        builder.startObject(4);
        HdfsBlockLocation.addStorageId(builder, storageIdOffset);
        HdfsBlockLocation.addDatanodeuuid(builder, datanodeuuidOffset);
        HdfsBlockLocation.addPort(builder, port);
        HdfsBlockLocation.addIpAddr(builder, ipAddrOffset);
        return HdfsBlockLocation.endHdfsBlockLocation(builder);
    }

    public static void startHdfsBlockLocation(FlatBufferBuilder builder) {
        builder.startObject(4);
    }

    public static void addIpAddr(FlatBufferBuilder builder, int ipAddrOffset) {
        builder.addOffset(0, ipAddrOffset, 0);
    }

    public static void addPort(FlatBufferBuilder builder, int port) {
        builder.addInt(1, port, 0);
    }

    public static void addDatanodeuuid(FlatBufferBuilder builder, int datanodeuuidOffset) {
        builder.addOffset(2, datanodeuuidOffset, 0);
    }

    public static void addStorageId(FlatBufferBuilder builder, int storageIdOffset) {
        builder.addOffset(3, storageIdOffset, 0);
    }

    public static int endHdfsBlockLocation(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

