/*
 * Decompiled with CFR 0.152.
 */
package bigboot.protocol.type;

import bigboot.protocol.type.ReplicaUCFeature;
import bigboot.protocol.type.TruncateHdfsBlock;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class HdfsBlockUCFeature
extends Table {
    public static HdfsBlockUCFeature getRootAsHdfsBlockUCFeature(ByteBuffer _bb) {
        return HdfsBlockUCFeature.getRootAsHdfsBlockUCFeature(_bb, new HdfsBlockUCFeature());
    }

    public static HdfsBlockUCFeature getRootAsHdfsBlockUCFeature(ByteBuffer _bb, HdfsBlockUCFeature obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public HdfsBlockUCFeature __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte blockUCState() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateBlockUCState(byte blockUCState) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, blockUCState);
            return true;
        }
        return false;
    }

    public ReplicaUCFeature replicas(int j) {
        return this.replicas(new ReplicaUCFeature(), j);
    }

    public ReplicaUCFeature replicas(ReplicaUCFeature obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int replicasLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public String truncateBlock() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer truncateBlockAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer truncateBlockInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public TruncateHdfsBlock truncateBlockAsTruncateHdfsBlock() {
        return this.truncateBlockAsTruncateHdfsBlock(new TruncateHdfsBlock());
    }

    public TruncateHdfsBlock truncateBlockAsTruncateHdfsBlock(TruncateHdfsBlock obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o)), this.bb) : null;
    }

    public int primaryNodeIndex() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : -1;
    }

    public boolean mutatePrimaryNodeIndex(int primaryNodeIndex) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, primaryNodeIndex);
            return true;
        }
        return false;
    }

    public long blockRecoveryId() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateBlockRecoveryId(long blockRecoveryId) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, blockRecoveryId);
            return true;
        }
        return false;
    }

    public static int createHdfsBlockUCFeature(FlatBufferBuilder builder, byte blockUCState, int replicasOffset, int truncateBlockOffset, int primaryNodeIndex, long blockRecoveryId) {
        builder.startObject(5);
        HdfsBlockUCFeature.addBlockRecoveryId(builder, blockRecoveryId);
        HdfsBlockUCFeature.addPrimaryNodeIndex(builder, primaryNodeIndex);
        HdfsBlockUCFeature.addTruncateBlock(builder, truncateBlockOffset);
        HdfsBlockUCFeature.addReplicas(builder, replicasOffset);
        HdfsBlockUCFeature.addBlockUCState(builder, blockUCState);
        return HdfsBlockUCFeature.endHdfsBlockUCFeature(builder);
    }

    public static void startHdfsBlockUCFeature(FlatBufferBuilder builder) {
        builder.startObject(5);
    }

    public static void addBlockUCState(FlatBufferBuilder builder, byte blockUCState) {
        builder.addByte(0, blockUCState, 0);
    }

    public static void addReplicas(FlatBufferBuilder builder, int replicasOffset) {
        builder.addOffset(1, replicasOffset, 0);
    }

    public static int createReplicasVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startReplicasVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addTruncateBlock(FlatBufferBuilder builder, int truncateBlockOffset) {
        builder.addOffset(2, truncateBlockOffset, 0);
    }

    public static void addPrimaryNodeIndex(FlatBufferBuilder builder, int primaryNodeIndex) {
        builder.addInt(3, primaryNodeIndex, -1);
    }

    public static void addBlockRecoveryId(FlatBufferBuilder builder, long blockRecoveryId) {
        builder.addLong(4, blockRecoveryId, 0L);
    }

    public static int endHdfsBlockUCFeature(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

