/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot;

import com.alibaba.jboot.JbootFuture;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.jni.NativeClass;
import com.alibaba.jboot.protocols.CltReaderRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class JbootHdfsReader
extends NativeClass {
    private final String path;
    private final long nsPtr;
    private final UserLoginInfo ugi;
    private boolean closed = false;
    private int DEFAULT_FUTURE_TIMEOUT = 600;

    public JbootHdfsReader(UserLoginInfo ugi, JindoRequestPath path) {
        this.ugi = ugi;
        this.path = path.getPath();
        this.nsPtr = path.getNsConnectorPtr();
    }

    public void read(long offset, long length, ByteBuffer buffer) throws IOException {
        this.read(offset, length, buffer, false, false);
    }

    public void randomRead(long offset, long length, ByteBuffer buffer, boolean readOssOnly) throws IOException {
        this.read(offset, length, buffer, readOssOnly, true);
    }

    public void read(long offset, long length, ByteBuffer buffer, boolean readOssOnly, boolean randomRead) throws IOException {
        this.read(offset, length, buffer, readOssOnly, randomRead, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public void read(long offset, long length, ByteBuffer buffer, boolean readOssOnly, boolean randomRead, int timeout) throws IOException {
        ByteBuffer request = new CltReaderRequestWrapper(this.ugi, new JindoRequestPath(this.path, this.nsPtr, null), offset, length, readOssOnly, randomRead).toDirectBuffer();
        try {
            JbootFuture f = this.read(request, buffer);
            buffer.position(0);
            buffer.limit((int)length);
            f.get(timeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JbootHdfsReader jbootHdfsReader = this;
        synchronized (jbootHdfsReader) {
            if (this.closed) {
                return;
            }
            this.destroy();
            this.closed = true;
        }
    }

    private native JbootFuture read(ByteBuffer var1, ByteBuffer var2);

    @Override
    protected native void destroy();
}

