/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot;

import com.alibaba.jboot.ErrorCode;
import com.alibaba.jboot.exception.ConnectionBreakException;
import com.alibaba.jboot.exception.ConnectionDownException;
import com.alibaba.jboot.exception.NodeServerBreakException;
import com.alibaba.jboot.exception.OtsConditionalUpdateException;
import com.alibaba.jboot.exception.ServiceHaException;
import com.alibaba.jboot.exception.ServiceHaUnderInitException;
import com.alibaba.jboot.exception.ServiceHaUnderStandbyException;
import com.alibaba.jboot.exception.ShouldIgnoreException;
import com.alibaba.jboot.exception.ShouldReturnFalseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileAlreadyExistsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JbootResult {
    private Object result;
    private Throwable error;

    void handleResult(Object result) {
        if (result instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)result;
            bb.position(0);
            bb.limit(bb.capacity());
        }
        this.result = result;
    }

    void handleError(int errorCode, String errorMsg) {
        errorMsg = this.trimErrMsg(errorMsg);
        switch (errorCode) {
            case 25000: 
            case 25001: {
                this.error = new FileAlreadyExistsException("ErrorCode : " + errorCode + " , ErrorMsg: " + (ErrorCode.ERROR_CODE_MAP.get(errorCode) == null ? errorMsg : ErrorCode.ERROR_CODE_MAP.get(errorCode) + ". " + errorMsg));
                break;
            }
            case 25002: {
                this.error = new FileNotFoundException("ErrorCode : " + errorCode + " , ErrorMsg: " + (ErrorCode.ERROR_CODE_MAP.get(errorCode) == null ? errorMsg : ErrorCode.ERROR_CODE_MAP.get(errorCode) + ". " + errorMsg));
                break;
            }
            case 25008: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25010: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25012: {
                this.error = new FileNotFoundException(errorMsg);
                break;
            }
            case 25014: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25015: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25016: {
                this.error = new Exception(errorMsg);
                break;
            }
            case 25025: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25026: {
                this.error = new ShouldIgnoreException(errorMsg);
                break;
            }
            case 23003: {
                this.error = new ConnectionDownException(errorMsg);
                break;
            }
            case 23004: {
                this.error = new ConnectionBreakException(errorMsg);
                break;
            }
            case 23005: {
                this.error = new NullPointerException(errorMsg);
                break;
            }
            case 24004: {
                this.error = new NodeServerBreakException(errorMsg);
                break;
            }
            case 26001: {
                this.error = new OtsConditionalUpdateException(errorMsg);
                break;
            }
            case 27000: {
                this.error = new ServiceHaException(errorMsg);
                break;
            }
            case 27001: {
                this.error = new ServiceHaUnderInitException(errorMsg);
                break;
            }
            case 27002: {
                this.error = new ServiceHaUnderStandbyException(errorMsg);
                break;
            }
            default: {
                this.error = new IOException(errorMsg);
            }
        }
    }

    private String trimErrMsg(String errorMsg) {
        if (errorMsg == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("^[\\[E\\d\\.:\\]]+");
        Matcher matcher = pattern.matcher(errorMsg);
        String out = matcher.replaceFirst("");
        return out;
    }

    public Object get() throws Throwable {
        if (this.error != null) {
            this.error.setStackTrace(new Exception().getStackTrace());
            throw this.error;
        }
        return this.result;
    }
}

