/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JniUtil.class);

    public static String throwableToString(Throwable t) {
        StringWriter output = new StringWriter();
        output.write(String.format("%s: %s", t.getClass().getSimpleName(), t.getMessage()));
        Throwable cause = t;
        while ((cause = cause.getCause()) != null) {
            output.write(String.format("\nCAUSED BY: %s: %s", cause.getClass().getSimpleName(), cause.getMessage()));
        }
        return output.toString();
    }

    public static String throwableToStackTrace(Throwable t) {
        StringWriter output = new StringWriter();
        t.printStackTrace(new PrintWriter(output));
        return ((Object)output).toString();
    }

    public static String getJavaVersion() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        StringBuilder sb = new StringBuilder();
        sb.append("Java Input arguments:\n");
        sb.append("\nJava System properties:\n");
        for (Map.Entry<String, String> entry : runtime.getSystemProperties().entrySet()) {
            sb.append(entry.getKey() + ":" + entry.getValue() + "\n");
        }
        return sb.toString();
    }
}

