/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot;

import com.alibaba.jboot.JbootUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;

public class NativeCodeLoader {
    private static boolean nativeCodeLoaded = false;
    private static String error;
    private static final String resourcePath = "/com/alibaba/jboot/native/";
    private static final String versionResourcePath = "/com/alibaba/jboot/native/VERSION";
    private static boolean isAnalysisLogDumped;
    private static StringBuilder analysisLogMsg;

    private NativeCodeLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Class<NativeCodeLoader> clazz = NativeCodeLoader.class;
        synchronized (NativeCodeLoader.class) {
            try {
                if (!nativeCodeLoaded) {
                    NativeCodeLoader.loadLibrary();
                    nativeCodeLoaded = true;
                }
            }
            catch (Throwable e) {
                String err = JbootUtils.stringifyException(e);
                System.err.println(err);
                error = err;
            }
            finally {
                String anaLog = analysisLogMsg.toString();
                if (anaLog.length() > 0) {
                    System.err.println(anaLog);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void checkOSType() {
        String os = System.getProperty("os.name");
        if ((os = os.toLowerCase()).startsWith("windows")) {
            throw new RuntimeException("OS type Windows is not supported. Only MacOS and Linux are supported.");
        }
    }

    static void loadLibrary() {
        NativeCodeLoader.checkOSType();
        if (NativeCodeLoader.tryLoadLibraryFromClasspath()) {
            return;
        }
        File tmpFolder = new File("/tmp");
        try {
            NativeCodeLoader.loadLibrary(tmpFolder);
        }
        catch (Throwable origEx) {
            File tmpFolder2 = new File(System.getProperty("java.io.tmpdir"));
            try {
                NativeCodeLoader.loadLibrary(tmpFolder2);
            }
            catch (Throwable e2) {
                throw origEx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadLibrary(File tmpFolder) {
        block20: {
            String version = NativeCodeLoader.getVersion();
            String libFileName = "libjboot-" + version + NativeCodeLoader.fileExtension();
            File sharedLibFile = new File(tmpFolder, libFileName);
            String libResourcePath = "/com/alibaba/jboot/native/libjboot-" + version + NativeCodeLoader.fileExtension();
            FileInputStream fileDiscriptorHolder = null;
            try {
                if (sharedLibFile.exists()) {
                    try {
                        fileDiscriptorHolder = new FileInputStream(sharedLibFile);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!sharedLibFile.exists()) {
                    NativeCodeLoader.extractLibraryFile(libResourcePath, sharedLibFile, tmpFolder);
                }
                if (!sharedLibFile.exists()) {
                    throw new RuntimeException(String.format("find library file at %s is not found", sharedLibFile));
                }
                if (!sharedLibFile.canExecute() || !sharedLibFile.canRead()) {
                    throw new RuntimeException(String.format("find library file at %s but cannot read", sharedLibFile));
                }
                try {
                    System.load(sharedLibFile.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError originEx) {
                    if (originEx.getMessage().contains("already loaded in another classloader")) {
                        try {
                            String uuid = UUID.randomUUID().toString();
                            String tmpLibFileName = "libjboot-" + version + "-" + uuid + NativeCodeLoader.fileExtension();
                            File copiedFile = new File(tmpFolder, tmpLibFileName);
                            Files.copy(sharedLibFile.toPath(), copiedFile.toPath(), new CopyOption[0]);
                            copiedFile.deleteOnExit();
                            NativeCodeLoader.setReadable(copiedFile);
                            System.load(copiedFile.getAbsolutePath());
                            break block20;
                        }
                        catch (Throwable quietEx) {
                            NativeCodeLoader.dumpAnalysisLog(sharedLibFile, originEx, quietEx);
                            throw originEx;
                        }
                    }
                    NativeCodeLoader.dumpAnalysisLog(sharedLibFile, originEx);
                    throw originEx;
                }
                catch (Throwable originEx) {
                    NativeCodeLoader.dumpAnalysisLog(sharedLibFile, originEx);
                    throw originEx;
                }
            }
            finally {
                if (fileDiscriptorHolder != null) {
                    try {
                        fileDiscriptorHolder.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public static void dumpAnalysisLog(File sharedLibFile, Throwable ... ex) {
        if (isAnalysisLogDumped) {
            return;
        }
        isAnalysisLogDumped = true;
        try {
            try {
                File f = new File(NativeCodeLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                analysisLogMsg.append("JbootSupport code source: ").append(f.getAbsolutePath()).append("\n");
            }
            catch (Throwable f) {
                // empty catch block
            }
            if (sharedLibFile != null) {
                long filelen = sharedLibFile.length();
                analysisLogMsg.append("sharedLibFile: ").append(sharedLibFile.getAbsolutePath()).append(" ").append(filelen).append(" bytes").append("\n");
            } else {
                analysisLogMsg.append("nativeLibFile is null \n");
            }
            analysisLogMsg.append("classloader jars:\n");
            for (ClassLoader cls = NativeCodeLoader.class.getClassLoader(); cls != null; cls = cls.getParent()) {
                if (!(cls instanceof URLClassLoader)) continue;
                URL[] urls = ((URLClassLoader)cls).getURLs();
                LinkedList<String> urlFilePathList = new LinkedList<String>();
                for (URL url : urls) {
                    String urlFilePath = url.getFile();
                    if (urlFilePath.contains("*")) {
                        File[] subFiles;
                        File urlFile = new File(urlFilePath);
                        File dir = urlFile.getParentFile();
                        if (!dir.isDirectory() || (subFiles = dir.listFiles()) == null) continue;
                        for (File subFile : subFiles) {
                            if (!subFile.isFile()) continue;
                            urlFilePathList.push(subFile.getAbsolutePath());
                        }
                        continue;
                    }
                    urlFilePathList.push(urlFilePath);
                }
                for (String urlFilePath : urlFilePathList) {
                    if (!urlFilePath.toLowerCase().contains("jindo") && !urlFilePath.toLowerCase().contains("smartdata") && !urlFilePath.toLowerCase().contains("bigboot") && !urlFilePath.toLowerCase().contains("juice")) continue;
                    File urlFile = new File(urlFilePath);
                    if (urlFile.isFile()) {
                        analysisLogMsg.append(urlFilePath).append(" ").append(urlFile.length()).append(" bytes").append("\n");
                        continue;
                    }
                    analysisLogMsg.append(urlFilePath).append("\n");
                }
            }
            String finalLogMsg = analysisLogMsg.toString();
            try {
                String fileName = "/tmp/jboot_load_native_err_" + System.currentTimeMillis();
                Path errFile = Paths.get(fileName, new String[0]);
                Files.write(errFile, Arrays.asList(finalLogMsg), StandardOpenOption.CREATE);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static File tmpFile(File tmpFolder) {
        String uuid = UUID.randomUUID().toString();
        String extractedLibFileName = String.format("libjboot-%s.so", uuid);
        File extractedLibFile = new File(tmpFolder, extractedLibFileName);
        return extractedLibFile;
    }

    private static void setReadable(File file) {
        if (!(file.setReadable(true, false) && file.setExecutable(true, false) && file.setWritable(true, false))) {
            throw new RuntimeException("Invalid path for library path");
        }
    }

    /*
     * Exception decompiling
     */
    public static String getVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String fileExtension() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isMacOs = osName.startsWith("mac");
        if (isMacOs) {
            return ".dylib";
        }
        return ".so";
    }

    private static void extractLibraryFile(String libResourcePath, File sharedLibFile, File tmpFolder) {
        long fileSize;
        block37: {
            File extractedLibFile = NativeCodeLoader.tmpFile(tmpFolder);
            byte[] buffer = new byte[8192];
            fileSize = 0L;
            try (InputStream reader = NativeCodeLoader.class.getResourceAsStream(libResourcePath);
                 FileOutputStream writer = new FileOutputStream(extractedLibFile);){
                int bytesRead;
                if (reader == null) {
                    NativeCodeLoader.dumpAnalysisLog(null, null);
                    throw new RuntimeException("resource " + libResourcePath + " not found, maybe incomplete compile package!");
                }
                while ((bytesRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, bytesRead);
                    fileSize += (long)bytesRead;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                extractedLibFile.deleteOnExit();
            }
            NativeCodeLoader.setReadable(extractedLibFile);
            if (fileSize != extractedLibFile.length()) {
                throw new RuntimeException(String.format("Failed to write a native library file at %s", extractedLibFile));
            }
            try {
                boolean renameResult = extractedLibFile.renameTo(sharedLibFile);
                if (!renameResult) {
                    throw new RuntimeException(String.format("Failed to rename file %s to %s", extractedLibFile, sharedLibFile));
                }
            }
            catch (SecurityException se) {
                if (sharedLibFile.exists()) break block37;
                throw new RuntimeException(se);
            }
        }
        if (fileSize != sharedLibFile.length()) {
            throw new RuntimeException(String.format("sharedLibFile %s file size is not expected, real is %ld expected is %ld", sharedLibFile, sharedLibFile.length(), fileSize));
        }
    }

    public static String getError() {
        return error;
    }

    static boolean tryLoadLibraryFromClasspath() {
        try {
            LinkedHashSet<File> urlDirSet = new LinkedHashSet<File>();
            ClassLoader cls = NativeCodeLoader.class.getClassLoader();
            NativeCodeLoader.collectUrlDir(cls, urlDirSet);
            cls = Thread.currentThread().getContextClassLoader();
            NativeCodeLoader.collectUrlDir(cls, urlDirSet);
            String version = NativeCodeLoader.getVersion();
            String libFileName = "libjboot-" + version + NativeCodeLoader.fileExtension();
            File libFile = null;
            for (File urlDir : urlDirSet) {
                File tryLibFile = new File(urlDir, libFileName);
                if (!tryLibFile.exists() || !tryLibFile.canRead()) continue;
                libFile = tryLibFile;
                break;
            }
            if (libFile != null) {
                System.load(libFile.getAbsolutePath());
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static void collectUrlDir(ClassLoader cls, Set<File> urlDirSet) {
        while (cls != null) {
            if (cls instanceof URLClassLoader) {
                URL[] urls;
                for (URL url : urls = ((URLClassLoader)cls).getURLs()) {
                    String urlFilePath = url.getFile();
                    File urlFile = new File(urlFilePath);
                    if (urlFile.isFile()) {
                        urlDirSet.add(urlFile.getParentFile());
                        continue;
                    }
                    if (urlFile.isDirectory()) {
                        urlDirSet.add(urlFile);
                        continue;
                    }
                    urlDirSet.add(urlFile.getParentFile());
                }
            }
            cls = cls.getParent();
        }
    }

    static {
        isAnalysisLogDumped = false;
        analysisLogMsg = new StringBuilder();
    }
}

