/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.AcceleratorInfo;
import bigboot.protocol.type.AcceleratorInfoRequest;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.CredentialContext;
import java.nio.ByteBuffer;

public class AcceleratorInfoRequestWrapper
extends JniRequestWrapper {
    private String acceleratorAddress;
    private String path;
    private String timeZone;
    private byte[] filterBytes;
    private byte[] projectBytes;
    private byte[] projectSchemaBytes;
    private String[] filedNames;
    private long uuid;
    private long start;
    private long length;
    private boolean hasComplexType;
    private boolean needInitLog;

    public AcceleratorInfoRequestWrapper(String acceleratorAddress, String path, byte[] filterBytes, byte[] projectBytes, byte[] projectSchemaBytes, String[] filedNames, boolean hasComplexType, String timeZone, long uuid, long start, long length, boolean needInitLog, CredentialContext credentialContext) {
        this.acceleratorAddress = acceleratorAddress;
        this.path = path;
        this.filterBytes = filterBytes;
        this.projectBytes = projectBytes;
        this.projectSchemaBytes = projectSchemaBytes;
        this.filedNames = filedNames;
        this.uuid = uuid;
        this.start = start;
        this.length = length;
        this.hasComplexType = hasComplexType;
        this.timeZone = timeZone;
        this.needInitLog = needInitLog;
        this.ossContext = credentialContext;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int acceleratorAddressOffset = ((FlatBufferBuilder)builder).createString(this.acceleratorAddress);
        int pathOffset = ((FlatBufferBuilder)builder).createString(this.path);
        int filterBytesOffset = 0;
        if (this.filterBytes != null) {
            filterBytesOffset = ((FlatBufferBuilder)builder).createString(ByteBuffer.wrap(this.filterBytes));
        }
        int projectBytesOffset = 0;
        if (this.projectBytes != null) {
            projectBytesOffset = ((FlatBufferBuilder)builder).createString(ByteBuffer.wrap(this.projectBytes));
        }
        int projectSchemaBytesOffset = 0;
        if (this.projectSchemaBytes != null) {
            projectSchemaBytesOffset = ((FlatBufferBuilder)builder).createString(ByteBuffer.wrap(this.projectSchemaBytes));
        }
        int timeZoneBytesOffset = ((FlatBufferBuilder)builder).createString(this.timeZone);
        int[] data = new int[this.filedNames.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((FlatBufferBuilder)builder).createString(this.filedNames[i]);
        }
        int filedNamesOffset = AcceleratorInfo.createFiledNamesVector(builder, data);
        AcceleratorInfo.startAcceleratorInfo(builder);
        AcceleratorInfo.addAcceleratorAddress(builder, acceleratorAddressOffset);
        AcceleratorInfo.addPath(builder, pathOffset);
        if (this.filterBytes != null) {
            AcceleratorInfo.addFilterBytes(builder, filterBytesOffset);
        }
        if (this.projectBytes != null) {
            AcceleratorInfo.addProjectBytes(builder, projectBytesOffset);
        }
        if (this.projectSchemaBytes != null) {
            AcceleratorInfo.addProjectSchemaBytes(builder, projectSchemaBytesOffset);
        }
        if (this.filedNames != null) {
            AcceleratorInfo.addFiledNames(builder, filedNamesOffset);
        }
        AcceleratorInfo.addTimeZone(builder, timeZoneBytesOffset);
        AcceleratorInfo.addUuid(builder, this.uuid);
        AcceleratorInfo.addStart(builder, this.start);
        AcceleratorInfo.addLength(builder, this.length);
        AcceleratorInfo.addHasComplexType(builder, this.hasComplexType);
        AcceleratorInfo.addNeedInitLog(builder, this.needInitLog);
        builder.finish(AcceleratorInfo.endAcceleratorInfo(builder));
        JbootFlatBufferBuilder builderRequest = new JbootFlatBufferBuilder();
        int requestHeaderOffset = this.getRequestHeader(builderRequest, "test", null);
        int acceleratorInfoOffset = builderRequest.createString(builder.dataBuffer());
        AcceleratorInfoRequest.startAcceleratorInfoRequest(builderRequest);
        AcceleratorInfoRequest.addRequestHeader(builderRequest, requestHeaderOffset);
        AcceleratorInfoRequest.addAccelerator(builderRequest, acceleratorInfoOffset);
        builderRequest.finish(AcceleratorInfoRequest.endAcceleratorInfoRequest(builderRequest));
        ByteBuffer buffer = builderRequest.dataBuffer();
        return buffer;
    }
}

