/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.NssBlockletFsckRequest;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import java.nio.ByteBuffer;

public class BlockletFsckRequestWrapper
extends JniRequestWrapper {
    private String marker;
    private String nsName;
    private int batchCount;
    private int cleanInterval;
    private String backendUri;

    public BlockletFsckRequestWrapper(UserLoginInfo ugi, String marker, String nsName, JindoRequestPath backendUri, int batchCount, int cleanInterval) {
        this.ugi = ugi;
        this.nsName = nsName;
        this.marker = marker;
        this.backendUri = backendUri.getPath();
        this.ossContext = backendUri.getOssContext();
        this.nsConnectorPtr = backendUri.getNsConnectorPtr();
        this.batchCount = batchCount;
        this.cleanInterval = cleanInterval;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int markerOffset = ((FlatBufferBuilder)builder).createString(this.marker);
        int backendUriOffset = ((FlatBufferBuilder)builder).createString(this.backendUri);
        int requestHeaderOffset = this.getRequestHeader(builder, this.nsName, null);
        NssBlockletFsckRequest.startNssBlockletFsckRequest(builder);
        NssBlockletFsckRequest.addMarker(builder, markerOffset);
        NssBlockletFsckRequest.addBatchCount(builder, this.batchCount);
        NssBlockletFsckRequest.addCleanInterval(builder, this.cleanInterval);
        NssBlockletFsckRequest.addRequestHeader(builder, requestHeaderOffset);
        NssBlockletFsckRequest.addBackendUri(builder, backendUriOffset);
        builder.finish(NssBlockletFsckRequest.endNssBlockletFsckRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }
}

