/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.CltRecoverRequest;
import bigboot.protocol.type.FlushInfo;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssFlushContext;
import java.nio.ByteBuffer;

public class ClientRecoverRequestWrapper
extends JniRequestWrapper {
    private String path;
    private boolean recursive;
    private OssFlushContext flushContext = null;

    public ClientRecoverRequestWrapper(UserLoginInfo ugi, String path, boolean recursive, OssFlushContext flushContext) {
        this.ugi = ugi;
        this.path = path;
        this.recursive = recursive;
        this.flushContext = flushContext;
    }

    public ClientRecoverRequestWrapper(UserLoginInfo ugi, JindoRequestPath path, boolean recursive, OssFlushContext flushContext) {
        this.ugi = ugi;
        this.path = path.getPath();
        this.ossContext = path.getOssContext();
        this.recursive = recursive;
        this.flushContext = flushContext;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int pathOffset = ((FlatBufferBuilder)builder).createString(this.path);
        int requestHeaderOffset = this.getRequestHeader(builder, this.getNsName(this.path), this.path);
        int flushInfoOffset = -1;
        if (this.flushContext != null) {
            flushInfoOffset = this.getFlushContext(builder);
        }
        CltRecoverRequest.startCltRecoverRequest(builder);
        CltRecoverRequest.addPath(builder, pathOffset);
        CltRecoverRequest.addRequestHeader(builder, requestHeaderOffset);
        CltRecoverRequest.addRecursive(builder, this.recursive);
        if (this.flushContext != null) {
            CltRecoverRequest.addFlushInfo(builder, flushInfoOffset);
        }
        builder.finish(CltRecoverRequest.endCltRecoverRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    private int getFlushContext(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int flushStagingPathOffset = ((FlatBufferBuilder)builder).createString(this.flushContext.flushStagingPath);
        FlushInfo.startFlushInfo(builder);
        FlushInfo.addFlushEnabled(builder, this.flushContext.flushEnabled);
        FlushInfo.addFlushStagingPath(builder, flushStagingPathOffset);
        builder.finish(FlushInfo.endFlushInfo(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }
}

