/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.AtomicRenameInfo;
import bigboot.protocol.type.CloudCredential;
import bigboot.protocol.type.CloudCredentialProvider;
import bigboot.protocol.type.CloudCredentialToken;
import bigboot.protocol.type.CltRenameRequest;
import bigboot.protocol.type.OtsInfo;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssAtomicRenameContext;
import com.aliyun.emr.utils.CollectionUtils;
import java.nio.ByteBuffer;

public class ClientRenameRequestWrapper
extends JniRequestWrapper {
    private String oldPath;
    private String newPath;
    private long copyPartSize;
    private boolean atomicRename;
    private boolean appendName;
    private boolean ignoreHidden;
    private int batchSize;
    private boolean prefixLink;
    private OssAtomicRenameContext ossAtomicRenameContext;

    public ClientRenameRequestWrapper(UserLoginInfo ugi, JindoRequestPath oldPath, String newPath, boolean appendName, boolean ignoreHidden, long copyPartSize, boolean atomicRename, int batchSize, boolean prefixLink, OssAtomicRenameContext ossAtomicRenameContext) {
        this.ugi = ugi;
        this.oldPath = oldPath.getPath();
        this.newPath = newPath;
        this.copyPartSize = copyPartSize;
        this.atomicRename = atomicRename;
        this.appendName = appendName;
        this.ignoreHidden = ignoreHidden;
        this.batchSize = batchSize;
        this.prefixLink = prefixLink;
        this.ossContext = oldPath.getOssContext();
        this.ossAtomicRenameContext = ossAtomicRenameContext;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int oldPathOffset = ((FlatBufferBuilder)builder).createString(this.oldPath);
        int newPathOffset = ((FlatBufferBuilder)builder).createString(this.newPath);
        int requestHeaderOffset = this.getRequestHeader(builder, this.getNsName(this.newPath), this.oldPath, this.newPath, this.prefixLink);
        int atomicRenameInfoOffset = this.getAtomicRenameInfo(builder);
        CltRenameRequest.startCltRenameRequest(builder);
        CltRenameRequest.addSrcPath(builder, oldPathOffset);
        CltRenameRequest.addDstPath(builder, newPathOffset);
        CltRenameRequest.addCopyPartSize(builder, this.copyPartSize);
        CltRenameRequest.addAtomicRenameInfo(builder, atomicRenameInfoOffset);
        CltRenameRequest.addAppendName(builder, this.appendName);
        CltRenameRequest.addIgnoreHidden(builder, this.ignoreHidden);
        CltRenameRequest.addPrefixLink(builder, this.prefixLink);
        CltRenameRequest.addBatchSize(builder, this.batchSize);
        CltRenameRequest.addRequestHeader(builder, requestHeaderOffset);
        builder.finish(CltRenameRequest.endCltRenameRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    private int getAtomicRenameInfo(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        if (this.atomicRename) {
            int otsInfoOffset = this.getOtsInfo(builder);
            AtomicRenameInfo.startAtomicRenameInfo(builder);
            AtomicRenameInfo.addAtomicRename(builder, this.atomicRename);
            AtomicRenameInfo.addType(builder, this.ossAtomicRenameContext.type);
            AtomicRenameInfo.addOtsInfo(builder, otsInfoOffset);
            AtomicRenameInfo.addTimeout(builder, this.ossAtomicRenameContext.timeout);
        } else {
            AtomicRenameInfo.startAtomicRenameInfo(builder);
            AtomicRenameInfo.addAtomicRename(builder, this.atomicRename);
        }
        builder.finish(AtomicRenameInfo.endAtomicRenameInfo(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }

    private int getOtsInfo(FlatBufferBuilder requestBuilder) {
        if (1 == this.ossAtomicRenameContext.type) {
            JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
            int otsTableNameOffset = !CollectionUtils.isNullOrEmpty(this.ossAtomicRenameContext.otsOptions.tableName) ? ((FlatBufferBuilder)builder).createString(this.ossAtomicRenameContext.otsOptions.tableName) : ((FlatBufferBuilder)builder).createString("");
            int otsEndpointOffset = !CollectionUtils.isNullOrEmpty(this.ossAtomicRenameContext.otsOptions.endpoint) ? ((FlatBufferBuilder)builder).createString(this.ossAtomicRenameContext.otsOptions.endpoint) : ((FlatBufferBuilder)builder).createString("");
            int otsCredentialOffset = this.getOtsCredential(builder);
            OtsInfo.startOtsInfo(builder);
            OtsInfo.addOtsTablename(builder, otsTableNameOffset);
            OtsInfo.addOtsEndpoint(builder, otsEndpointOffset);
            OtsInfo.addCredentials(builder, otsCredentialOffset);
            builder.finish(OtsInfo.endOtsInfo(builder));
            return requestBuilder.createString(builder.dataBuffer());
        }
        return requestBuilder.createString("");
    }

    private int getOtsCredential(FlatBufferBuilder requestBuilder) {
        int credentialOffset;
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        boolean isToken = false;
        if (!CollectionUtils.isNullOrEmpty(this.ossAtomicRenameContext.otsOptions.accessKeyId) && !CollectionUtils.isNullOrEmpty(this.ossAtomicRenameContext.otsOptions.accessKeySecret)) {
            isToken = true;
            credentialOffset = this.getTokenCredential(builder);
        } else {
            credentialOffset = this.getTokenProvider(builder);
        }
        CloudCredential.startCloudCredential(builder);
        CloudCredential.addIsToken(builder, isToken);
        if (isToken) {
            CloudCredential.addToken(builder, credentialOffset);
        } else {
            CloudCredential.addProvider(builder, credentialOffset);
        }
        builder.finish(CloudCredential.endCloudCredential(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }

    private int getTokenCredential(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int accessKeyIdOffset = ((FlatBufferBuilder)builder).createString(this.ossAtomicRenameContext.otsOptions.accessKeyId);
        int accessKeySecretOffset = ((FlatBufferBuilder)builder).createString(this.ossAtomicRenameContext.otsOptions.accessKeySecret);
        int securityTokenOffset = !CollectionUtils.isNullOrEmpty(this.ossAtomicRenameContext.otsOptions.securityToken) ? ((FlatBufferBuilder)builder).createString(this.ossAtomicRenameContext.otsOptions.securityToken) : ((FlatBufferBuilder)builder).createString("");
        CloudCredentialToken.startCloudCredentialToken(builder);
        CloudCredentialToken.addAccessKeyId(builder, accessKeyIdOffset);
        CloudCredentialToken.addAccessKeySecret(builder, accessKeySecretOffset);
        CloudCredentialToken.addAccessKeyToken(builder, securityTokenOffset);
        builder.finish(CloudCredentialToken.endCloudCredentialToken(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }

    private int getTokenProvider(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int endPointOffset = ((FlatBufferBuilder)builder).createString(this.ossAtomicRenameContext.otsOptions.providerEndpoint);
        CloudCredentialProvider.startCloudCredentialProvider(builder);
        CloudCredentialProvider.addEndpoint(builder, endPointOffset);
        CloudCredentialProvider.addFormat(builder, this.ossAtomicRenameContext.otsOptions.format);
        builder.finish(CloudCredentialProvider.endCloudCredentialProvider(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }
}

