/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.FlushInfo;
import bigboot.protocol.type.NssCacheFileletCreateRequest;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssFlushContext;
import java.nio.ByteBuffer;

public class FileletCacheCreateRequestWrapper
extends JniRequestWrapper {
    private String path;
    private String storageOption;
    private String checksumInfo = null;
    private OssFlushContext flushContext = null;
    private int bufferSize;

    public FileletCacheCreateRequestWrapper(UserLoginInfo ugi, JindoRequestPath path, String storageOption, OssFlushContext flushContext, int bufferSize) {
        this.ugi = ugi;
        this.path = path.getPath();
        this.ossContext = path.getOssContext();
        this.nsConnectorPtr = path.getNsConnectorPtr();
        this.storageOption = storageOption;
        this.ossContext = path.getOssContext();
        this.flushContext = flushContext;
        this.bufferSize = bufferSize;
    }

    public FileletCacheCreateRequestWrapper(UserLoginInfo ugi, JindoRequestPath path, String storageOption, String checksumInfo, OssFlushContext flushContext, int bufferSize) {
        this.ugi = ugi;
        this.path = path.getPath();
        this.ossContext = path.getOssContext();
        this.nsConnectorPtr = path.getNsConnectorPtr();
        this.storageOption = storageOption;
        this.ossContext = path.getOssContext();
        this.checksumInfo = checksumInfo;
        this.flushContext = flushContext;
        this.bufferSize = bufferSize;
    }

    byte getStorageOption(String storageOption) {
        if (storageOption.equals("Standard")) {
            return 1;
        }
        if (storageOption.equals("IA")) {
            return 2;
        }
        if (storageOption.equals("Archive")) {
            return 3;
        }
        if (storageOption.equals("ColdArchive")) {
            return 4;
        }
        return 0;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int pathOffset = ((FlatBufferBuilder)builder).createString(this.path);
        int requestHeaderOffset = this.getRequestHeader(builder, this.getNsName(this.path), this.path);
        int checksumOffset = -1;
        if (this.checksumInfo != null) {
            checksumOffset = ((FlatBufferBuilder)builder).createString(this.checksumInfo);
        }
        int flushInfoOffset = -1;
        if (this.flushContext != null) {
            flushInfoOffset = this.getFlushContext(builder);
        }
        NssCacheFileletCreateRequest.startNssCacheFileletCreateRequest(builder);
        NssCacheFileletCreateRequest.addStorageOption(builder, this.getStorageOption(this.storageOption));
        NssCacheFileletCreateRequest.addPath(builder, pathOffset);
        NssCacheFileletCreateRequest.addRequestHeader(builder, requestHeaderOffset);
        if (this.checksumInfo != null) {
            NssCacheFileletCreateRequest.addChecksumInfo(builder, checksumOffset);
        }
        if (this.flushContext != null) {
            NssCacheFileletCreateRequest.addFlushInfo(builder, flushInfoOffset);
        }
        NssCacheFileletCreateRequest.addBufferSize(builder, this.bufferSize);
        builder.finish(NssCacheFileletCreateRequest.endNssCacheFileletCreateRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    private int getFlushContext(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int flushStagingPathOffset = ((FlatBufferBuilder)builder).createString(this.flushContext.flushStagingPath);
        FlushInfo.startFlushInfo(builder);
        FlushInfo.addFlushEnabled(builder, this.flushContext.flushEnabled);
        FlushInfo.addFlushStagingPath(builder, flushStagingPathOffset);
        builder.finish(FlushInfo.endFlushInfo(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }
}

