/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.ManifestRecord;
import bigboot.protocol.type.ManifestRecords;
import bigboot.protocol.type.NssClose2Request;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import java.nio.ByteBuffer;
import java.util.List;

public class FileletClose2RequestWrapper
extends JniRequestWrapper {
    private final String owner;
    private final String group;
    private List<String> paths;
    private List<String> fileIds;
    private List<Long> sizes;
    private String path;
    private final boolean abort;

    public FileletClose2RequestWrapper(UserLoginInfo ugi, JindoRequestPath path, List<String> paths, List<String> fileIds, List<Long> sizes, String owner, String group, boolean abort) {
        this.ugi = ugi;
        this.paths = paths;
        this.fileIds = fileIds;
        this.sizes = sizes;
        this.path = path.getPath();
        this.owner = owner;
        this.group = group;
        this.ossContext = path.getOssContext();
        this.abort = abort;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int requestHeaderOffset = this.getRequestHeader(builder, this.getNsName(this.path), this.path);
        JbootFlatBufferBuilder recordsBuilder = new JbootFlatBufferBuilder();
        int size = this.paths.size();
        int[] recordOffsets = new int[size];
        for (int i = 0; i < this.paths.size(); ++i) {
            String tmpPath = this.paths.get(i);
            int pathOffset = ((FlatBufferBuilder)recordsBuilder).createString(tmpPath);
            int fileIdOffset = ((FlatBufferBuilder)recordsBuilder).createString(this.fileIds.get(i));
            recordOffsets[i] = ManifestRecord.createManifestRecord(recordsBuilder, pathOffset, fileIdOffset, this.sizes.get(i));
        }
        int recordsoffset = recordsBuilder.createVectorOfTables(recordOffsets);
        ManifestRecords.startManifestRecords(recordsBuilder);
        ManifestRecords.addRecords(recordsBuilder, recordsoffset);
        recordsBuilder.finish(ManifestRecords.endManifestRecords(recordsBuilder));
        int ownerOffset = ((FlatBufferBuilder)builder).createString(this.owner);
        int GroupOffset = ((FlatBufferBuilder)builder).createString(this.group);
        int offset = ((FlatBufferBuilder)builder).createString(recordsBuilder.dataBuffer());
        NssClose2Request.startNssClose2Request(builder);
        NssClose2Request.addRequestHeader(builder, requestHeaderOffset);
        NssClose2Request.addRecords(builder, offset);
        NssClose2Request.addOwner(builder, ownerOffset);
        NssClose2Request.addGroup(builder, GroupOffset);
        NssClose2Request.addAbort(builder, this.abort);
        builder.finish(NssClose2Request.endNssClose2Request(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }
}

