/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.NssFileletOpenRequest;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import java.nio.ByteBuffer;

public class FileletOpenRequestWrapper
extends JniRequestWrapper {
    private String path;
    private boolean ossOnly;
    private boolean dataVerify;
    private String inodeId = null;
    private long size = 0L;
    private int bufferSize;

    public FileletOpenRequestWrapper(UserLoginInfo ugi, JindoRequestPath path, boolean ossOnly, boolean dataVerify, int bufferSize, String inodeId, long size) {
        this.ugi = ugi;
        this.path = path.getPath();
        this.ossContext = path.getOssContext();
        this.nsConnectorPtr = path.getNsConnectorPtr();
        this.ossOnly = ossOnly;
        this.dataVerify = dataVerify;
        this.inodeId = inodeId;
        this.size = size;
        this.bufferSize = bufferSize;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int pathOffset = ((FlatBufferBuilder)builder).createString(this.path);
        int requestHeaderOffset = this.getRequestHeader(builder, this.getNsName(this.path), this.path);
        if (this.inodeId != null) {
            int inodeIdOffset = ((FlatBufferBuilder)builder).createString(this.inodeId);
            NssFileletOpenRequest.startNssFileletOpenRequest(builder);
            NssFileletOpenRequest.addInodeId(builder, inodeIdOffset);
            NssFileletOpenRequest.addSize(builder, this.size);
        } else {
            NssFileletOpenRequest.startNssFileletOpenRequest(builder);
        }
        NssFileletOpenRequest.addPath(builder, pathOffset);
        NssFileletOpenRequest.addRequestHeader(builder, requestHeaderOffset);
        NssFileletOpenRequest.addOssOnly(builder, this.ossOnly);
        NssFileletOpenRequest.addDataVerify(builder, this.dataVerify);
        NssFileletOpenRequest.addBufferSize(builder, this.bufferSize);
        builder.finish(NssFileletOpenRequest.endNssFileletOpenRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }
}

