/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.CloudCredential;
import bigboot.protocol.type.CloudCredentialProvider;
import bigboot.protocol.type.CloudCredentialToken;
import bigboot.protocol.type.RequestHeader;
import bigboot.protocol.type.UserRequestHeader;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jfs.CredentialContext;
import com.aliyun.emr.utils.CollectionUtils;
import com.aliyun.emr.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class JniRequestWrapper {
    protected long nsConnectorPtr = 0L;
    protected UserLoginInfo ugi;
    protected CredentialContext ossContext;
    public static String CACHE_MODE_NS_NAME;
    public static String STREAM_CACHE_MODE_NS_NAME;
    public static String EMPTY_NS_NAME;
    private static String ip;

    public ByteBuffer toDirectBuffer() {
        return this.toFbBuffer();
    }

    protected abstract ByteBuffer toFbBuffer();

    public String getNsName(String pathStr) {
        try {
            String scheme = "";
            String authority = "";
            int start = 0;
            int colon = pathStr.indexOf(58);
            int slash = pathStr.indexOf(47);
            if (colon != -1 && (slash == -1 || colon < slash)) {
                scheme = pathStr.substring(0, colon);
                start = colon + 1;
            }
            if (pathStr.startsWith("//", start) && pathStr.length() - start > 2) {
                int nextSlash = pathStr.indexOf(47, start + 2);
                int authEnd = nextSlash > 0 ? nextSlash : pathStr.length();
                authority = pathStr.substring(start + 2, authEnd);
                start = authEnd;
            }
            String path = pathStr.substring(start, pathStr.length());
            URI uri = new URI(scheme, authority, path, null, null).normalize();
            if (scheme.equalsIgnoreCase("oss") || scheme.equalsIgnoreCase("s3") || scheme.equalsIgnoreCase("s3a") || scheme.equalsIgnoreCase("s3n") || scheme.equalsIgnoreCase("cos") || scheme.equalsIgnoreCase("obs")) {
                return CACHE_MODE_NS_NAME;
            }
            if (scheme.equalsIgnoreCase("jfs")) {
                String host = uri.getHost();
                String[] parts = host.split("\\.");
                if (parts.length == 1) {
                    return parts[0];
                }
                return parts[0] + "." + parts[1];
            }
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            new IllegalArgumentException(e);
            return "";
        }
    }

    protected int getRequestHeader(FlatBufferBuilder requestBuilder, String nsName, String oldPath, String newPath, boolean prefixLink) {
        int ossCredentialOffset;
        String username = "oss";
        try {
            if (this.ugi != null) {
                username = this.ugi.getShortUserName();
            }
            if (username == null) {
                username = "oss";
            }
        }
        catch (Throwable e) {
            username = "oss";
        }
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int usernameOffset = ((FlatBufferBuilder)builder).createString(username);
        int nsNameOffset = ((FlatBufferBuilder)builder).createString(nsName);
        int ipOffset = ((FlatBufferBuilder)builder).createString(ip);
        int ossEndpointOffset = ((FlatBufferBuilder)builder).createString("");
        if (this.ossContext != null) {
            int credentialOffset;
            JbootFlatBufferBuilder ossBuilder = new JbootFlatBufferBuilder();
            boolean isToken = false;
            if (!CollectionUtils.isNullOrEmpty(this.ossContext.accessKeyId) && !CollectionUtils.isNullOrEmpty(this.ossContext.accessKeySecret)) {
                isToken = true;
                credentialOffset = this.getTokenCredential(ossBuilder);
            } else {
                credentialOffset = this.getTokenProvider(ossBuilder);
            }
            CloudCredential.startCloudCredential(ossBuilder);
            CloudCredential.addIsToken(ossBuilder, isToken);
            if (isToken) {
                CloudCredential.addToken(ossBuilder, credentialOffset);
            } else {
                CloudCredential.addProvider(ossBuilder, credentialOffset);
            }
            ossBuilder.finish(CloudCredential.endCloudCredential(ossBuilder));
            ossCredentialOffset = ((FlatBufferBuilder)builder).createString(ossBuilder.dataBuffer());
            if (this.ossContext.endpoint != null) {
                ossEndpointOffset = ((FlatBufferBuilder)builder).createString(this.ossContext.endpoint);
            }
        } else {
            ossCredentialOffset = ((FlatBufferBuilder)builder).createString("");
        }
        boolean useSLD = false;
        boolean enableHttps = false;
        int retryCount = -1;
        long timeout = -1L;
        long connectionTimeout = -1L;
        if (this.ossContext != null) {
            useSLD = this.ossContext.useSLD;
            enableHttps = this.ossContext.enableHttps;
            retryCount = this.ossContext.retryCount;
            timeout = this.ossContext.timeout;
            connectionTimeout = this.ossContext.connectionTimeout;
        }
        if (this.ossContext != null && this.ossContext.enableHiveFastRename && !prefixLink) {
            String srcPrefixPath = JniRequestWrapper.getCommonPath(oldPath);
            String dstPrefixPath = JniRequestWrapper.getCommonPath(newPath);
            if (StringUtils.isNotEmpty(srcPrefixPath) && StringUtils.isNotEmpty(dstPrefixPath)) {
                try {
                    String encodedSrcPrefix = URLEncoder.encode(srcPrefixPath, "UTF-8");
                    int srcHeaderKeyOffset = ((FlatBufferBuilder)builder).createString("x-oss-prefix-link-copy-source-destination-prefix");
                    int srcHeaderValueOffset = ((FlatBufferBuilder)builder).createString(encodedSrcPrefix);
                    String encodedDstPrefix = URLEncoder.encode(dstPrefixPath, "UTF-8");
                    int dstHeaderKeyOffset = ((FlatBufferBuilder)builder).createString("x-oss-prefix-link-destination-prefix");
                    int dstHeaderValueOffset = ((FlatBufferBuilder)builder).createString(encodedDstPrefix);
                    int[] headerOffset = new int[]{UserRequestHeader.createUserRequestHeader(builder, srcHeaderKeyOffset, srcHeaderValueOffset), UserRequestHeader.createUserRequestHeader(builder, dstHeaderKeyOffset, dstHeaderValueOffset)};
                    int userRequestHeadersOffset = builder.createVectorOfTables(headerOffset);
                    RequestHeader.startRequestHeader(builder);
                    RequestHeader.addUserRequestHeaders(builder, userRequestHeadersOffset);
                }
                catch (UnsupportedEncodingException e) {
                    RequestHeader.startRequestHeader(builder);
                }
            } else if (StringUtils.isNotEmpty(srcPrefixPath)) {
                try {
                    String encodedSrcPrefix = URLEncoder.encode(srcPrefixPath, "UTF-8");
                    int headerKeyOffset = ((FlatBufferBuilder)builder).createString("x-oss-prefix-link-copy-source-destination-prefix");
                    int headerValueOffset = ((FlatBufferBuilder)builder).createString(encodedSrcPrefix);
                    int[] headerOffset = new int[]{UserRequestHeader.createUserRequestHeader(builder, headerKeyOffset, headerValueOffset)};
                    int userRequestHeadersOffset = builder.createVectorOfTables(headerOffset);
                    RequestHeader.startRequestHeader(builder);
                    RequestHeader.addUserRequestHeaders(builder, userRequestHeadersOffset);
                }
                catch (UnsupportedEncodingException e) {
                    RequestHeader.startRequestHeader(builder);
                }
            } else if (StringUtils.isNotEmpty(dstPrefixPath)) {
                try {
                    String encodedDstPrefix = URLEncoder.encode(dstPrefixPath, "UTF-8");
                    int headerKeyOffset = ((FlatBufferBuilder)builder).createString("x-oss-prefix-link-destination-prefix");
                    int headerValueOffset = ((FlatBufferBuilder)builder).createString(encodedDstPrefix);
                    int[] headerOffset = new int[]{UserRequestHeader.createUserRequestHeader(builder, headerKeyOffset, headerValueOffset)};
                    int userRequestHeadersOffset = builder.createVectorOfTables(headerOffset);
                    RequestHeader.startRequestHeader(builder);
                    RequestHeader.addUserRequestHeaders(builder, userRequestHeadersOffset);
                }
                catch (UnsupportedEncodingException e) {
                    RequestHeader.startRequestHeader(builder);
                }
            } else {
                RequestHeader.startRequestHeader(builder);
            }
        } else {
            RequestHeader.startRequestHeader(builder);
        }
        RequestHeader.addUsername(builder, usernameOffset);
        RequestHeader.addNsName(builder, nsNameOffset);
        RequestHeader.addIp(builder, ipOffset);
        RequestHeader.addCredentials(builder, ossCredentialOffset);
        RequestHeader.addNsConnectorPtr(builder, this.nsConnectorPtr);
        RequestHeader.addOssEndpoint(builder, ossEndpointOffset);
        RequestHeader.addUseSLD(builder, useSLD);
        RequestHeader.addEnableHttps(builder, enableHttps);
        RequestHeader.addRetryCount(builder, retryCount);
        RequestHeader.addTimeout(builder, timeout);
        RequestHeader.addConnectionTimeout(builder, connectionTimeout);
        int requestHeaderOffset = RequestHeader.endRequestHeader(builder);
        builder.finish(requestHeaderOffset);
        return requestBuilder.createString(builder.dataBuffer());
    }

    protected int getRequestHeader(FlatBufferBuilder requestBuilder, String nsName, String path) {
        int ossCredentialOffset;
        String username = "oss";
        try {
            if (this.ugi != null) {
                username = this.ugi.getShortUserName();
            }
            if (username == null) {
                username = "oss";
            }
        }
        catch (Throwable e) {
            username = "oss";
        }
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int usernameOffset = ((FlatBufferBuilder)builder).createString(username);
        int nsNameOffset = ((FlatBufferBuilder)builder).createString(nsName);
        int ipOffset = ((FlatBufferBuilder)builder).createString(ip);
        int ossEndpointOffset = ((FlatBufferBuilder)builder).createString("");
        if (this.ossContext != null) {
            int credentialOffset;
            JbootFlatBufferBuilder ossBuilder = new JbootFlatBufferBuilder();
            boolean isToken = false;
            if (!CollectionUtils.isNullOrEmpty(this.ossContext.accessKeyId) && !CollectionUtils.isNullOrEmpty(this.ossContext.accessKeySecret)) {
                isToken = true;
                credentialOffset = this.getTokenCredential(ossBuilder);
            } else {
                credentialOffset = this.getTokenProvider(ossBuilder);
            }
            CloudCredential.startCloudCredential(ossBuilder);
            CloudCredential.addIsToken(ossBuilder, isToken);
            if (isToken) {
                CloudCredential.addToken(ossBuilder, credentialOffset);
            } else {
                CloudCredential.addProvider(ossBuilder, credentialOffset);
            }
            ossBuilder.finish(CloudCredential.endCloudCredential(ossBuilder));
            ossCredentialOffset = ((FlatBufferBuilder)builder).createString(ossBuilder.dataBuffer());
            if (this.ossContext.endpoint != null) {
                ossEndpointOffset = ((FlatBufferBuilder)builder).createString(this.ossContext.endpoint);
            }
        } else {
            ossCredentialOffset = ((FlatBufferBuilder)builder).createString("");
        }
        boolean useSLD = false;
        boolean enableHttps = false;
        int retryCount = -1;
        long timeout = -1L;
        long connectionTimeout = -1L;
        if (this.ossContext != null) {
            useSLD = this.ossContext.useSLD;
            enableHttps = this.ossContext.enableHttps;
            retryCount = this.ossContext.retryCount;
            timeout = this.ossContext.timeout;
            connectionTimeout = this.ossContext.connectionTimeout;
        }
        if (this.ossContext != null && this.ossContext.enableHiveFastRename && path != null) {
            String commonPrefixPath = JniRequestWrapper.getCommonPath(path);
            if (StringUtils.isNotEmpty(commonPrefixPath)) {
                try {
                    String encodedCommonPrefix = URLEncoder.encode(commonPrefixPath, "UTF-8");
                    int headerKeyOffset = ((FlatBufferBuilder)builder).createString("x-oss-prefix-link-destination-prefix");
                    int headerValueOffset = ((FlatBufferBuilder)builder).createString(encodedCommonPrefix);
                    int[] headerOffset = new int[]{UserRequestHeader.createUserRequestHeader(builder, headerKeyOffset, headerValueOffset)};
                    int userRequestHeadersOffset = builder.createVectorOfTables(headerOffset);
                    RequestHeader.startRequestHeader(builder);
                    RequestHeader.addUserRequestHeaders(builder, userRequestHeadersOffset);
                }
                catch (UnsupportedEncodingException e) {
                    RequestHeader.startRequestHeader(builder);
                }
            } else {
                RequestHeader.startRequestHeader(builder);
            }
        } else {
            RequestHeader.startRequestHeader(builder);
        }
        RequestHeader.addUsername(builder, usernameOffset);
        RequestHeader.addNsName(builder, nsNameOffset);
        RequestHeader.addIp(builder, ipOffset);
        RequestHeader.addCredentials(builder, ossCredentialOffset);
        RequestHeader.addNsConnectorPtr(builder, this.nsConnectorPtr);
        RequestHeader.addOssEndpoint(builder, ossEndpointOffset);
        RequestHeader.addUseSLD(builder, useSLD);
        RequestHeader.addEnableHttps(builder, enableHttps);
        RequestHeader.addRetryCount(builder, retryCount);
        RequestHeader.addTimeout(builder, timeout);
        RequestHeader.addConnectionTimeout(builder, connectionTimeout);
        int requestHeaderOffset = RequestHeader.endRequestHeader(builder);
        builder.finish(requestHeaderOffset);
        return requestBuilder.createString(builder.dataBuffer());
    }

    protected static String getCommonPath(String OriginPath) {
        String path = "";
        if (!OriginPath.startsWith("oss://")) {
            return "";
        }
        path = OriginPath.replace("oss://", "/");
        try {
            boolean foundHiveStagingComponent = false;
            boolean foundHiveStagingDstComponent = false;
            List<String> components = JniRequestWrapper.getJindoPathComponents(path);
            String bucketPrefix = "";
            for (String comp : components) {
                if (bucketPrefix == "") {
                    bucketPrefix = comp;
                }
                if (comp.startsWith(".hive-staging_hive_")) {
                    if (!foundHiveStagingComponent) {
                        foundHiveStagingComponent = true;
                        continue;
                    }
                    foundHiveStagingComponent = false;
                    break;
                }
                if (!comp.startsWith("-ext-100")) continue;
                if (!foundHiveStagingDstComponent) {
                    foundHiveStagingDstComponent = true;
                    continue;
                }
                foundHiveStagingDstComponent = false;
                break;
            }
            if (foundHiveStagingComponent && foundHiveStagingDstComponent) {
                return path.substring(bucketPrefix.length() + 2, path.indexOf("-ext-100") + 10) + "/";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static List<String> getJindoPathComponents(String path) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String component : path.split("/")) {
            if (component.isEmpty()) continue;
            ret.add(component);
        }
        return ret;
    }

    private int getTokenCredential(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int accessKeyIdOffset = ((FlatBufferBuilder)builder).createString(this.ossContext.accessKeyId);
        int accessKeySecretOffset = ((FlatBufferBuilder)builder).createString(this.ossContext.accessKeySecret);
        int securityTokenOffset = !CollectionUtils.isNullOrEmpty(this.ossContext.securityToken) ? ((FlatBufferBuilder)builder).createString(this.ossContext.securityToken) : ((FlatBufferBuilder)builder).createString("");
        CloudCredentialToken.startCloudCredentialToken(builder);
        CloudCredentialToken.addAccessKeyId(builder, accessKeyIdOffset);
        CloudCredentialToken.addAccessKeySecret(builder, accessKeySecretOffset);
        CloudCredentialToken.addAccessKeyToken(builder, securityTokenOffset);
        builder.finish(CloudCredentialToken.endCloudCredentialToken(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }

    private int getTokenProvider(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int endPointOffset = ((FlatBufferBuilder)builder).createString(this.ossContext.providerEndpoint);
        CloudCredentialProvider.startCloudCredentialProvider(builder);
        CloudCredentialProvider.addEndpoint(builder, endPointOffset);
        CloudCredentialProvider.addFormat(builder, this.ossContext.format);
        builder.finish(CloudCredentialProvider.endCloudCredentialProvider(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }

    static {
        STREAM_CACHE_MODE_NS_NAME = CACHE_MODE_NS_NAME = "cache_ns";
        EMPTY_NS_NAME = "empty_ns";
        ip = null;
        try {
            ip = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

