/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.CltMetaStatusRequest;
import bigboot.protocol.type.CryptoKey;
import bigboot.protocol.type.KeyCreateRequest;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.aliyun.emr.utils.CollectionUtils;
import java.nio.ByteBuffer;

public class KeyCreateRequestWrapper
extends JniRequestWrapper {
    String keyIdName;
    String keyIdVersion;
    String description;
    String encryptionKeyId;

    public KeyCreateRequestWrapper(UserLoginInfo ugi, String keyIdName, String keyIdVersion, String description, String encryptionKeyId) {
        this.ugi = ugi;
        this.keyIdName = keyIdName;
        this.keyIdVersion = keyIdVersion;
        this.description = description;
        this.encryptionKeyId = encryptionKeyId;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int requestHeaderOffset = this.getRequestHeader(builder, EMPTY_NS_NAME, null);
        int cryptoKeyOffset = this.getCryptoKey(builder);
        KeyCreateRequest.startKeyCreateRequest(builder);
        KeyCreateRequest.addCryptoKey(builder, cryptoKeyOffset);
        CltMetaStatusRequest.addRequestHeader(builder, requestHeaderOffset);
        builder.finish(CltMetaStatusRequest.endCltMetaStatusRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    private int getCryptoKey(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int keyIdNameOffset = this.getStringOffset(builder, this.keyIdName);
        int keyIdVersionOffset = this.getStringOffset(builder, this.keyIdVersion);
        int descriptionOffset = this.getStringOffset(builder, this.description);
        int encryptionKeyIdOffset = this.getStringOffset(builder, this.encryptionKeyId);
        CryptoKey.startCryptoKey(builder);
        CryptoKey.addKeyIdName(builder, keyIdNameOffset);
        CryptoKey.addKeyIdVersion(builder, keyIdVersionOffset);
        CryptoKey.addDescription(builder, descriptionOffset);
        CryptoKey.addEncryptionKeyId(builder, encryptionKeyIdOffset);
        builder.finish(CryptoKey.endCryptoKey(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }

    private int getStringOffset(FlatBufferBuilder builder, String value) {
        int offset = !CollectionUtils.isNullOrEmpty(value) ? builder.createString(value) : builder.createString("");
        return offset;
    }
}

