/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.retry;

import com.alibaba.jboot.JbootUtils;
import com.alibaba.jboot.exception.ConnectionBreakException;
import com.alibaba.jboot.exception.ConnectionDownException;
import com.alibaba.jboot.exception.NodeServerBreakException;
import com.alibaba.jboot.exception.OtsConditionalUpdateException;
import com.alibaba.jboot.exception.ServiceHaException;
import com.alibaba.jboot.exception.ServiceHaUnderInitException;
import com.alibaba.jboot.exception.ServiceHaUnderStandbyException;
import com.alibaba.jboot.retry.RetryPolicy;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class RetryPolicies {
    public static final RetryPolicy TRY_ONCE_THEN_FAIL = new TryOnceThenFail();
    public static final RetryPolicy RETRY_FOREVER = new RetryForever();
    private static final int MAX_RETRIES = 20;
    private static final long SLEEP_TIME = 1L;
    private static final long MAX_SLEEP_TIME = 10L;
    public static final boolean IDEMPOTENT_METHOD = true;
    public static final boolean NOT_IDEMPOTENT_METHOD = false;
    public static RetryPolicy RETRY_NORMAL = RetryPolicies.exponentialBackoffRetry(20, 1L, 10L, TimeUnit.SECONDS);

    public static final RetryPolicy retryForeverWithFixedSleep(long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithFixedSleep(Integer.MAX_VALUE, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithFixedSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithProportionalSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy exponentialBackoffRetry(int maxRetries, long sleepTime, long maxSleepTime, TimeUnit timeUnit) {
        return new ExponentialBackoffRetry(maxRetries, sleepTime, maxSleepTime, timeUnit);
    }

    private static long calculateExponentialTime(long time, int retries, long cap) {
        long baseTime = Math.min(time * (1L << retries), cap);
        return (long)((double)baseTime * (ThreadLocalRandom.current().nextDouble() + 0.5));
    }

    private static long calculateExponentialTime(long time, int retries) {
        return RetryPolicies.calculateExponentialTime(time, retries, Long.MAX_VALUE);
    }

    public static boolean shouldRetry(RetryPolicy retryPolicy, String operation, IOException e, int retryCount, boolean isIdempotent) {
        boolean skipRetry = true;
        boolean haException = false;
        if (RetryPolicies.isExceptionAssignableFrom(e, ConnectionBreakException.class)) {
            skipRetry = false;
        } else if (RetryPolicies.isExceptionAssignableFrom(e, ConnectionDownException.class)) {
            skipRetry = false;
        } else if (RetryPolicies.isExceptionAssignableFrom(e, OtsConditionalUpdateException.class)) {
            skipRetry = false;
        } else if (RetryPolicies.isExceptionAssignableFrom(e, ServiceHaException.class)) {
            skipRetry = false;
            haException = true;
        } else if (RetryPolicies.isExceptionAssignableFrom(e, ServiceHaUnderInitException.class)) {
            skipRetry = false;
            haException = true;
        } else if (RetryPolicies.isExceptionAssignableFrom(e, ServiceHaUnderStandbyException.class)) {
            skipRetry = false;
            haException = true;
        } else if (RetryPolicies.isExceptionAssignableFrom(e, NodeServerBreakException.class)) {
            skipRetry = false;
        }
        if (!skipRetry) {
            try {
                RetryPolicy.RetryAction retryAction = retryPolicy.shouldRetry(e, retryCount);
                boolean retry = retryAction.action.equals((Object)RetryPolicy.RetryAction.RETRY.action);
                if (retry && (!haException || retryCount > 3)) {
                    JbootUtils.logRetryException(operation, retryCount, retryAction.delayMillis, e);
                    Thread.sleep(retryAction.delayMillis);
                }
                return retry;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception ignored) {
                return false;
            }
        }
        return false;
    }

    private static boolean isExceptionAssignableFrom(Throwable e, Class clz) {
        while (e != null) {
            if (clz.isAssignableFrom(e.getClass())) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    static class ExponentialBackoffRetry
    extends RetryLimited {
        private final long maxSleepTime;

        public ExponentialBackoffRetry(int maxRetries, long sleepTime, long maxSleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
            this.maxSleepTime = maxSleepTime;
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " < 0");
            }
            if (maxRetries >= 63) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " >= " + 63);
            }
        }

        @Override
        protected long calculateSleepTime(int retries) {
            long sleepTimeCal = RetryPolicies.calculateExponentialTime(this.sleepTime, retries + 1);
            return this.maxSleepTime > sleepTimeCal ? sleepTimeCal : this.maxSleepTime;
        }
    }

    static class RetryUpToMaximumCountWithProportionalSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime * (long)(retries + 1);
        }
    }

    static class RetryUpToMaximumCountWithFixedSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime;
        }
    }

    static abstract class RetryLimited
    implements RetryPolicy {
        final int maxRetries;
        final long sleepTime;
        final TimeUnit timeUnit;
        private String myString;

        RetryLimited(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " < 0");
            }
            if (sleepTime < 0L) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime + " < 0");
            }
            this.maxRetries = maxRetries;
            this.sleepTime = sleepTime;
            this.timeUnit = timeUnit;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries) throws Exception {
            if (retries >= this.maxRetries) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, this.getReason());
            }
            return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY, this.timeUnit.toMillis(this.calculateSleepTime(retries)), this.getReason());
        }

        protected String getReason() {
            return RetryLimited.constructReasonString(this.maxRetries);
        }

        public static String constructReasonString(int retries) {
            return "retries get failed due to exceeded maximum allowed retries number: " + retries;
        }

        protected abstract long calculateSleepTime(int var1);

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return this.toString().equals(that.toString());
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + "(maxRetries=" + this.maxRetries + ", sleepTime=" + this.sleepTime + " " + (Object)((Object)this.timeUnit) + ")";
            }
            return this.myString;
        }
    }

    static class RetryForever
    implements RetryPolicy {
        RetryForever() {
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries) throws Exception {
            return RetryPolicy.RetryAction.RETRY;
        }
    }

    static class TryOnceThenFail
    implements RetryPolicy {
        TryOnceThenFail() {
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries) throws Exception {
            return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "try once and fail.");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

