/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.CredentialInitializationException;
import com.aliyun.emr.fs.auth.JindoCredentialsProvider;
import com.aliyun.emr.fs.auth.NoAuthWithAliyunException;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import com.aliyun.emr.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AliyunCredentialProviderList
implements AliyunCredentialsProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunCredentialProviderList.class);
    public static final String NO_ALIYUN_CREDENTIAL_PROVIDERS = "No Aliyun Credential Providers";
    static final String CREDENTIALS_REQUESTED_WHEN_CLOSED = "Credentials requested after provider list was closed";
    private final List<AliyunCredentialsProvider> providers = new ArrayList<AliyunCredentialsProvider>(1);
    private boolean reuseLastProvider = true;
    private AliyunCredentialsProvider lastProvider;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String name = "";

    public AliyunCredentialProviderList() {
    }

    public AliyunCredentialProviderList(Collection<AliyunCredentialsProvider> providers) {
        this.providers.addAll(providers);
    }

    public AliyunCredentialProviderList(String name, AliyunCredentialsProvider ... providerArgs) {
        this.setName(name);
        Collections.addAll(this.providers, providerArgs);
    }

    public JindoCredentialsProvider getJindoCredentialsProvider() throws IOException {
        JindoCredentialsProvider result;
        List resultList = this.providers.stream().filter(provider -> provider instanceof JindoCredentialsProvider).map(provider -> (JindoCredentialsProvider)provider).collect(Collectors.toList());
        if (resultList.size() >= 1) {
            result = (JindoCredentialsProvider)resultList.get(0);
            if (resultList.size() > 1) {
                throw new IOException("ERROR: more than one password less credential provider configured: " + Arrays.toString(resultList.stream().map(r -> r.getClass()).toArray()) + ". Only support one password less credential provider.");
            }
            if (!result.equals(this.providers.get(this.providers.size() - 1))) {
                throw new IOException("ERROR: the password less credential provider\uff1a" + result.getClass() + " should be configured at last.");
            }
        } else {
            throw new IOException("ERROR: without login secrets configured.");
        }
        return result;
    }

    public void setName(String name) {
        this.name = !name.isEmpty() && !name.endsWith(": ") ? name + ": " : name;
    }

    public void add(AliyunCredentialsProvider p) {
        this.providers.add(p);
    }

    public void addAll(AliyunCredentialProviderList other) {
        this.providers.addAll(other.providers);
    }

    @Override
    public void refresh() {
        if (this.isClosed()) {
            return;
        }
        for (AliyunCredentialsProvider provider : this.providers) {
            provider.refresh();
        }
    }

    @Override
    public AliyunCredentials getCredentials() {
        if (this.isClosed()) {
            LOG.warn(CREDENTIALS_REQUESTED_WHEN_CLOSED);
            throw new NoAuthWithAliyunException(this.name + CREDENTIALS_REQUESTED_WHEN_CLOSED);
        }
        this.checkNotEmpty();
        if (this.reuseLastProvider && this.lastProvider != null) {
            return this.lastProvider.getCredentials();
        }
        CredentialInitializationException lastException = null;
        for (AliyunCredentialsProvider provider : this.providers) {
            try {
                AliyunCredentials credentials = provider.getCredentials();
                Preconditions.checkNotNull(credentials, "Null credentials returned by %s", provider);
                if (credentials.getAccessKeyId() == null || credentials.getAccessKeySecret() == null) continue;
                this.lastProvider = provider;
                LOG.debug("Using credentials from {}", (Object)provider);
                return credentials;
            }
            catch (CredentialInitializationException e) {
                lastException = e;
                LOG.debug("No credentials provided by {}: {}", new Object[]{provider, e.toString(), e});
            }
        }
        String message = this.name + "No Aliyun Credentials provided by " + this.listProviderNames();
        if (lastException != null) {
            message = message + ": " + lastException;
        }
        LOG.debug(message);
        return null;
    }

    @VisibleForTesting
    List<AliyunCredentialsProvider> getProviders() {
        return this.providers;
    }

    public void checkNotEmpty() {
        if (this.providers.isEmpty()) {
            throw new NoAuthWithAliyunException(this.name + NO_ALIYUN_CREDENTIAL_PROVIDERS);
        }
    }

    public String listProviderNames() {
        return this.providers.stream().map(provider -> provider.getClass().getSimpleName() + ' ').collect(Collectors.joining());
    }

    public String toString() {
        return "AliyunCredentialProviderList[" + this.name + "refcount= " + this.refCount.get() + ": [" + StringUtils.join(this.providers, ", ") + ']' + (this.lastProvider != null ? " last provider: " + this.lastProvider : "");
    }

    public synchronized AliyunCredentialProviderList share() {
        Preconditions.checkState(!this.closed.get(), "Provider list is closed");
        this.refCount.incrementAndGet();
        return this;
    }

    @VisibleForTesting
    public int getRefCount() {
        return this.refCount.get();
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AliyunCredentialProviderList aliyunCredentialProviderList = this;
        synchronized (aliyunCredentialProviderList) {
            if (this.closed.get()) {
                return;
            }
            int remainder = this.refCount.decrementAndGet();
            if (remainder != 0) {
                LOG.debug("Not closing {}", (Object)this);
                return;
            }
            LOG.debug("Closing {}", (Object)this);
            this.closed.set(true);
        }
        for (AliyunCredentialsProvider p : this.providers) {
            if (p instanceof Closeable) {
                IOUtils.closeStream((Closeable)((Closeable)((Object)p)));
                continue;
            }
            if (!(p instanceof AutoCloseable)) continue;
            AuthUtils.closeAutocloseables(LOG, (AutoCloseable)((Object)p));
        }
    }

    public int size() {
        return this.providers.size();
    }
}

