/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.EcsStsCredentialsProvider;
import com.aliyun.emr.fs.auth.EnvironmentVariableCredentialsProvider;
import com.aliyun.emr.fs.auth.JindoCommonCredentialsProvider;
import com.aliyun.emr.fs.auth.SimpleAliyunCredentialsProvider;
import com.aliyun.emr.fs.internal.oss.OssLoginHelper;
import com.aliyun.emr.fs.internal.oss.ProviderUtils;
import com.aliyun.emr.fs.oss.Constants;
import com.aliyun.emr.fs.oss.JindoOssFileSystem;
import com.aliyun.emr.shade.apache_commons_codec.binary.Hex;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import com.aliyun.emr.shade.google_guava.collect.Lists;
import com.aliyun.emr.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    static final Logger LOG = LoggerFactory.getLogger(AuthUtils.class);
    public static final PathFilter ACCEPT_ALL = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };
    public static final String CONSTRUCTOR_EXCEPTION = "constructor exception";
    public static final String INSTANTIATION_EXCEPTION = "instantiation exception";
    public static final String NOT_ALIYUN_PROVIDER = "does not implement AliyunCredentialsProvider";
    public static final String ABSTRACT_PROVIDER = "is abstract and therefore cannot be created";
    public static final String ENDPOINT_KEY = "Endpoint";
    public static final String E_FS_CLOSED = "FileSystem is closed!";
    public static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
    public static final String BUCKET_PATTERN = "fs.jfs.cache.oss.bucket.%s.%s";
    public static final String ACCESS_KEY_ID_ENV_VAR = "ALIYUN_ACCESS_KEY_ID";
    public static final String ACCESS_KEY_SECRET_ENV_VAR = "ALIYUN_ACCESS_KEY_SECRET";
    public static final String ALIYUN_SECURITY_TOKEN_ENV_VAR = "ALIYUN_SECURITY_TOKEN";
    public static final String ALIYUN_REGION_ENV_VAR = "ALIYUN_REGION";
    public static final String OTS_ACCESS_KEY_ID_ENV_VAR = "OTS_ACCESS_KEY_ID";
    public static final String OTS_ACCESS_KEY_SECRET_ENV_VAR = "OTS_ACCESS_KEY_SECRET";
    public static final String OTS_SECURITY_TOKEN_ENV_VAR = "OTS_SECURITY_TOKEN";
    @VisibleForTesting
    public static final String E_FORBIDDEN_ALIYUN_PROVIDER = "ALIYUN provider class cannot be used";
    public static final List<Class<?>> OSS_STANDARD_ALIYUN_PROVIDERS = Collections.unmodifiableList(Arrays.asList(SimpleAliyunCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class, JindoCommonCredentialsProvider.class));
    public static final List<Class<?>> JFS_STANDARD_ALIYUN_PROVIDERS = Collections.unmodifiableList(Arrays.asList(SimpleAliyunCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class, JindoCommonCredentialsProvider.class, EcsStsCredentialsProvider.class));
    public static final List<Class<?>> OTS_STANDARD_ALIYUN_PROVIDERS = Collections.unmodifiableList(Arrays.asList(SimpleAliyunCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class, JindoCommonCredentialsProvider.class, EcsStsCredentialsProvider.class));

    static boolean shouldIgnore(Exception exception) {
        String eMessage = exception.getMessage();
        if (eMessage == null) {
            eMessage = "";
        }
        return eMessage.contains("NoSuchKey");
    }

    static void handleException(String message, Exception e) throws IOException {
        LOG.error(message, (Throwable)e);
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException(message, e);
    }

    static Path keyToPath(String key) {
        return new Path(key);
    }

    public static String hashFilePath(String prefix, Path filePath) {
        String fileDir;
        String fileUri = filePath.toUri().toString();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            fileDir = Hex.encodeHexString(md.digest(fileUri.getBytes()));
        }
        catch (Exception e) {
            fileDir = fileUri.replaceAll("/", "_").replace(":", "_");
        }
        String result = prefix + "-" + fileDir;
        return result;
    }

    static String convertToCacheDir(String ... cacheDirParts) {
        boolean skippedFirst = false;
        StringBuilder path = new StringBuilder();
        for (String key : cacheDirParts) {
            if (skippedFirst) {
                path.append("-");
            } else {
                skippedFirst = true;
            }
            path.append(AuthUtils.normalize(key));
        }
        return path.toString();
    }

    private static String normalize(String text) {
        return text == null ? "" : text.toLowerCase().trim();
    }

    public static void closeAll(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing {}", (Object)c);
                }
                c.close();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Exception in closing {}", (Object)c, (Object)e);
            }
        }
    }

    public static boolean objectRepresentsDirectory(String name, long size) {
        return !name.isEmpty() && name.charAt(name.length() - 1) == '/' && size == 0L;
    }

    public static String maybeAddTrailingSlash(String key) {
        if (!key.isEmpty() && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    public static String lookupOssPassword(String bucket, Configuration conf, String key, String ... deprecatedKeys) throws IOException {
        String value = AuthUtils.lookupPassword(bucket, conf, key, "fs.jfs.cache.oss.");
        if (StringUtils.isEmpty(value) && deprecatedKeys != null) {
            for (int i = 0; i < deprecatedKeys.length; ++i) {
                if (StringUtils.isEmpty(deprecatedKeys[i]) || !StringUtils.isNotEmpty(value = AuthUtils.lookupPassword(bucket, conf, deprecatedKeys[i], Constants.DEPRECATED_FS_OSS_PREFIX[i]))) continue;
                LOG.warn("{} is deprecated, please use: {}", (Object)deprecatedKeys, (Object)key);
                return value;
            }
        }
        return value;
    }

    public static OssLoginHelper.Login getAliyunAccessKeys(URI name, Configuration conf, AliyunCredentialsProvider.CredentialType type) throws IOException {
        String securityToken;
        String accessKeySecret;
        String accessKeyId;
        if (type == AliyunCredentialsProvider.CredentialType.OSS) {
            OssLoginHelper.Login login = OssLoginHelper.extractLoginDetails(name);
            if (login.hasLogin()) {
                return login;
            }
            Configuration c = ProviderUtils.excludeIncompatibleCredentialProviders(conf, JindoOssFileSystem.class);
            String bucket = name != null ? name.getHost() : "";
            accessKeyId = AuthUtils.lookupOssPassword(bucket, c, "fs.jfs.cache.oss.accessKeyId", Constants.DEPRECATED_OSS_ACCESS_KEY_ID);
            accessKeySecret = AuthUtils.lookupOssPassword(bucket, c, "fs.jfs.cache.oss.accessKeySecret", Constants.DEPRECATED_OSS_ACCESS_KEY_SECRET);
            securityToken = AuthUtils.lookupOssPassword(bucket, c, "fs.jfs.cache.oss.securityToken", Constants.DEPRECATED_OSS_SECURITY_TOKEN);
        } else if (type == AliyunCredentialsProvider.CredentialType.OTS) {
            accessKeyId = AuthUtils.getPassword(conf, "fs.jfs.cache.ots.accessKeyId", null, "");
            accessKeySecret = AuthUtils.getPassword(conf, "fs.jfs.cache.ots.accessKeySecret", null, "");
            securityToken = AuthUtils.getPassword(conf, "fs.jfs.cache.ots.securityToken", null, "");
        } else if (type == AliyunCredentialsProvider.CredentialType.JFS) {
            accessKeyId = AuthUtils.getPassword(conf, "fs.jfs.accessKeyId", null, "");
            accessKeySecret = AuthUtils.getPassword(conf, "fs.jfs.accessKeySecret", null, "");
            securityToken = AuthUtils.getPassword(conf, "fs.jfs.securityToken", null, "");
        } else {
            throw new IOException("WARNING: wrong credential type: " + type.name());
        }
        return new OssLoginHelper.Login(accessKeyId, accessKeySecret, securityToken);
    }

    public static String lookupPassword(String bucket, Configuration conf, String baseKey, String prefix) throws IOException {
        return AuthUtils.lookupPassword(bucket, conf, baseKey, prefix, null, "");
    }

    public static String lookupPassword(String bucket, Configuration conf, String baseKey, String prefix, String overrideVal, String defVal) throws IOException {
        String initialVal;
        Preconditions.checkArgument(baseKey.startsWith(prefix), "%s does not start with $%s", baseKey, prefix);
        if (StringUtils.isNotEmpty(bucket)) {
            String subkey = baseKey.substring(prefix.length());
            String shortBucketKey = String.format(BUCKET_PATTERN, bucket, subkey);
            String longBucketKey = String.format(BUCKET_PATTERN, bucket, baseKey);
            initialVal = AuthUtils.getPassword(conf, longBucketKey, overrideVal);
            initialVal = AuthUtils.getPassword(conf, shortBucketKey, initialVal);
        } else {
            initialVal = overrideVal;
        }
        return AuthUtils.getPassword(conf, baseKey, initialVal, defVal);
    }

    private static String getPassword(Configuration conf, String key, String val) throws IOException {
        return AuthUtils.getPassword(conf, key, val, "");
    }

    public static String getPassword(Configuration conf, String key, String val, String defVal) throws IOException {
        return StringUtils.isEmpty(val) ? AuthUtils.lookupPassword(conf, key, defVal) : val;
    }

    static String lookupPassword(Configuration conf, String key, String defVal) throws IOException {
        try {
            char[] pass = conf.getPassword(key);
            return pass != null ? new String(pass).trim() : defVal;
        }
        catch (IOException ioe) {
            throw new IOException("Cannot find password option " + key, ioe);
        }
    }

    public static boolean setIfDefined(Configuration config, String key, String val, String origin) {
        if (StringUtils.isNotEmpty(val)) {
            config.set(key, val, origin);
            return true;
        }
        return false;
    }

    public static AliyunCredentialProviderList createAliyunCredentialProviderSet(@Nullable URI binding, Configuration conf, AliyunCredentialsProvider.CredentialType type) throws IOException {
        AliyunCredentialProviderList providerList;
        if (type == AliyunCredentialsProvider.CredentialType.OSS) {
            providerList = AuthUtils.buildAliyunProviderList(binding, conf, "fs.jfs.cache.oss.credentials.provider", OSS_STANDARD_ALIYUN_PROVIDERS, new HashSet(), type);
        } else if (type == AliyunCredentialsProvider.CredentialType.OTS) {
            providerList = AuthUtils.buildAliyunProviderList(binding, conf, "fs.jfs.cache.ots.credentials.provider", OTS_STANDARD_ALIYUN_PROVIDERS, new HashSet(), type);
        } else if (type == AliyunCredentialsProvider.CredentialType.JFS) {
            providerList = AuthUtils.buildAliyunProviderList(binding, conf, "fs.jfs.credentials.provider", JFS_STANDARD_ALIYUN_PROVIDERS, new HashSet(), type);
        } else {
            throw new IOException("Wrong credential type: " + type.name());
        }
        LOG.debug("For URI {}, using credential providers {}", (Object)binding, (Object)providerList);
        return providerList;
    }

    public static List<Class<?>> loadAliyunProviderClasses(Configuration conf, String key, Class<?> ... defaultValue) throws IOException {
        try {
            return Arrays.asList(conf.getClasses(key, (Class[])defaultValue));
        }
        catch (RuntimeException e) {
            Throwable c = e.getCause() != null ? e.getCause() : e;
            throw new IOException("From option " + key + ' ' + c, c);
        }
    }

    public static AliyunCredentialProviderList buildAliyunProviderList(@Nullable URI binding, Configuration conf, String key, List<Class<?>> defaultValues, Set<Class<?>> forbidden, AliyunCredentialsProvider.CredentialType type) throws IOException {
        List<Class<?>> aliyunClasses = AuthUtils.loadAliyunProviderClasses(conf, key, defaultValues.toArray(new Class[defaultValues.size()]));
        if (aliyunClasses.isEmpty()) {
            aliyunClasses = defaultValues;
        }
        AliyunCredentialProviderList providers = new AliyunCredentialProviderList();
        for (Class<?> aClass : aliyunClasses) {
            if (forbidden.contains(aClass)) {
                throw new IOException("ALIYUN provider class cannot be used in option " + key + ": " + aClass);
            }
            providers.add(AuthUtils.createAliyunCredentialProvider(conf, aClass, binding, type));
        }
        return providers;
    }

    private static AliyunCredentialsProvider createAliyunCredentialProvider(Configuration conf, Class<?> credClass, @Nullable URI uri, AliyunCredentialsProvider.CredentialType type) throws IOException {
        AliyunCredentialsProvider credentials = null;
        String className = credClass.getName();
        if (!AliyunCredentialsProvider.class.isAssignableFrom(credClass)) {
            throw new IOException("Class " + credClass + " " + NOT_ALIYUN_PROVIDER);
        }
        if (Modifier.isAbstract(credClass.getModifiers())) {
            throw new IOException("Class " + credClass + " " + ABSTRACT_PROVIDER);
        }
        LOG.debug("Credential provider class is {}", (Object)className);
        try {
            Constructor<?> cons = AuthUtils.getConstructor(credClass, URI.class, Configuration.class, AliyunCredentialsProvider.CredentialType.class);
            if (cons != null) {
                credentials = (AliyunCredentialsProvider)cons.newInstance(new Object[]{uri, conf, type});
                return credentials;
            }
            cons = AuthUtils.getConstructor(credClass, Configuration.class, AliyunCredentialsProvider.CredentialType.class);
            if (cons != null) {
                credentials = (AliyunCredentialsProvider)cons.newInstance(new Object[]{conf, type});
                return credentials;
            }
            cons = AuthUtils.getConstructor(credClass, AliyunCredentialsProvider.CredentialType.class);
            if (cons != null) {
                credentials = (AliyunCredentialsProvider)cons.newInstance(new Object[]{type});
                return credentials;
            }
            Method factory = AuthUtils.getFactoryMethod(credClass, AliyunCredentialsProvider.class, "getInstance");
            if (factory != null) {
                credentials = (AliyunCredentialsProvider)factory.invoke(null, new Object[]{type});
                return credentials;
            }
            cons = AuthUtils.getConstructor(credClass, new Class[0]);
            if (cons != null) {
                credentials = (AliyunCredentialsProvider)cons.newInstance(new Object[0]);
                return credentials;
            }
            throw new IOException(String.format("%s constructor exception.  A class specified in %s must provide a public constructor of a supported signature, or a public factory method named getInstance that accepts no arguments.", className, "fs.jfs.cache.oss.credentials.provider"));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException == null) {
                targetException = e;
            }
            if (targetException instanceof IOException) {
                throw (IOException)targetException;
            }
            throw new IOException(className + " " + INSTANTIATION_EXCEPTION + ": " + targetException, targetException);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new IOException(className + " " + INSTANTIATION_EXCEPTION + ": " + e, e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> cl, Class<?> ... args) {
        try {
            Constructor<?> cons = cl.getDeclaredConstructor(args);
            return Modifier.isPublic(cons.getModifiers()) ? cons : null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static Method getFactoryMethod(Class<?> cl, Class<?> returnType, String methodName) {
        try {
            Method m = cl.getDeclaredMethod(methodName, new Class[0]);
            if (Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers()) && returnType.isAssignableFrom(m.getReturnType())) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    public static void closeAutocloseables(Logger log, AutoCloseable ... closeables) {
        if (log == null) {
            log = LOG;
        }
        for (AutoCloseable c : closeables) {
            if (c == null) continue;
            try {
                log.debug("Closing {}", (Object)c);
                c.close();
            }
            catch (Exception e) {
                log.debug("Exception in closing {}", (Object)c, (Object)e);
            }
        }
    }

    public static Configuration propagateBucketOptions(Configuration source, String bucket) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(bucket), "bucket");
        String bucketPrefix = "fs.jfs.cache.oss.bucket." + bucket + '.';
        LOG.debug("Propagating entries under {}", (Object)bucketPrefix);
        Configuration dest = new Configuration(source);
        for (Map.Entry entry : source) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(bucketPrefix) || bucketPrefix.equals(key)) continue;
            String stripped = key.substring(bucketPrefix.length());
            if (stripped.startsWith("bucket.") || "impl".equals(stripped)) {
                LOG.debug("Ignoring bucket option {}", (Object)key);
                continue;
            }
            String origin = "[" + StringUtils.join((Object[])source.getPropertySources(key), ", ") + "]";
            String generic = "fs.jfs.cache.oss." + stripped;
            LOG.debug("Updating {} from {}", (Object)generic, (Object)origin);
            dest.set(generic, value, key + " via " + origin);
        }
        return dest;
    }

    public static Configuration propagateNamespaceOptions(Configuration source, String namespace) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(namespace), "namespace");
        String namespacePrefix = "fs.jfs.ns." + namespace + '.';
        LOG.debug("Propagating entries under {}", (Object)namespacePrefix);
        Configuration dest = new Configuration(source);
        for (Map.Entry entry : source) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(namespacePrefix) || namespacePrefix.equals(key)) continue;
            String stripped = key.substring(namespacePrefix.length());
            String origin = "[" + StringUtils.join((Object[])source.getPropertySources(key), ", ") + "]";
            String generic = "fs.jfs." + stripped;
            LOG.debug("Updating {} from {}", (Object)generic, (Object)origin);
            dest.set(generic, value, key + " via " + origin);
        }
        return dest;
    }

    public static void patchSecurityCredentialProviders(Configuration conf) {
        Collection customCredentials = conf.getStringCollection("fs.jfs.cache.oss.security.credential.provider.path");
        Collection hadoopCredentials = conf.getStringCollection(CREDENTIAL_PROVIDER_PATH);
        if (!customCredentials.isEmpty()) {
            ArrayList all = Lists.newArrayList(customCredentials);
            all.addAll(hadoopCredentials);
            String joined = StringUtils.join(all, ',');
            LOG.debug("Setting {} to {}", (Object)CREDENTIAL_PROVIDER_PATH, (Object)joined);
            conf.set(CREDENTIAL_PROVIDER_PATH, joined, "patch of fs.jfs.cache.oss.security.credential.provider.path");
        }
    }

    public static void setBucketOption(Configuration conf, String bucket, String genericKey, String value) {
        String baseKey = genericKey.startsWith("fs.jfs.cache.oss.") ? genericKey.substring("fs.jfs.cache.oss.".length()) : genericKey;
        conf.set("fs.jfs.cache.oss.bucket." + bucket + '.' + baseKey, value, "AuthUtils");
    }

    public static void setNamespaceOption(Configuration conf, String namespace, String genericKey, String value) {
        String baseKey = genericKey.startsWith("fs.jfs.") ? genericKey.substring("fs.jfs.".length()) : genericKey;
        conf.set("fs.jfs.ns." + namespace + '.' + baseKey, value, "AuthUtils");
    }
}

