/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.JindoCredentialsProvider;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;

public class CupidStsCredentialsProvider
extends JindoCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.auth.CupidStsCredentialsProvider";
    private static final String HOST = "localhost";
    private static final int PORT = 10011;
    private static final String TOKEN_INFO_URL = "/sts-token-info";

    public CupidStsCredentialsProvider(@Nullable URI uri, Configuration conf, AliyunCredentialsProvider.CredentialType type) {
        super(uri, conf, type);
    }

    @Override
    public String getStsProviderUrl() throws IOException {
        String uid = AuthUtils.lookupOssPassword(this.getBucket(), this.getConf(), "fs.jfs.cache.oss.uid", new String[0]);
        String role = AuthUtils.lookupOssPassword(this.getBucket(), this.getConf(), "fs.jfs.cache.oss.role", new String[0]);
        String policy = AuthUtils.lookupOssPassword(this.getBucket(), this.getConf(), "fs.jfs.cache.oss.policy", new String[0]);
        return "http://localhost:10011/sts-token-info?user_id=" + uid + "&role=" + role + "&policy=" + policy;
    }

    @Override
    public JindoCredentialsProvider.CredentialsTokenFormat getTokenFormat() {
        return JindoCredentialsProvider.CredentialsTokenFormat.JSON;
    }
}

