/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.NoAliyunCredentialsException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public abstract class JindoCredentialsProvider
implements AliyunCredentialsProvider {
    private final URI binding;
    private final Configuration conf;
    private final String bucket;
    private final AliyunCredentialsProvider.CredentialType type;

    public JindoCredentialsProvider(URI uri, Configuration conf, AliyunCredentialsProvider.CredentialType type) {
        this.binding = uri;
        this.conf = conf;
        this.bucket = uri != null ? uri.getHost() : "";
        this.type = type;
    }

    @Override
    public AliyunCredentials getCredentials() {
        throw new NoAliyunCredentialsException("JindoCredentialsProvider", "No Aliyun credentials in the configuration");
    }

    @Override
    public void refresh() {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public URI getUri() {
        return this.binding;
    }

    public String getBucket() {
        return this.bucket;
    }

    public AliyunCredentialsProvider.CredentialType getType() {
        return this.type;
    }

    public abstract String getStsProviderUrl() throws IOException;

    public abstract CredentialsTokenFormat getTokenFormat();

    public static enum CredentialsTokenFormat {
        PLAIN,
        JSON;

    }
}

