/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.BasicCredentials;
import com.aliyun.emr.fs.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.auth.NoAliyunCredentialsException;
import com.aliyun.emr.fs.internal.oss.OssLoginHelper;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
public class SimpleAliyunCredentialsProvider
implements AliyunCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.auth.SimpleAliyunCredentialsProvider";
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String securityToken;

    public SimpleAliyunCredentialsProvider(URI uri, Configuration conf, AliyunCredentialsProvider.CredentialType type) throws IOException {
        this(AuthUtils.getAliyunAccessKeys(uri, conf, type));
    }

    @VisibleForTesting
    SimpleAliyunCredentialsProvider(OssLoginHelper.Login login) {
        this.accessKeyId = login.getUser();
        this.accessKeySecret = login.getPassword();
        this.securityToken = login.getToken();
    }

    @Override
    public AliyunCredentials getCredentials() {
        if (!StringUtils.isEmpty(this.accessKeyId) && !StringUtils.isEmpty(this.accessKeySecret)) {
            if (!StringUtils.isEmpty(this.securityToken)) {
                return new BasicSessionCredentials(this.accessKeyId, this.accessKeySecret, this.securityToken);
            }
            return new BasicCredentials(this.accessKeyId, this.accessKeySecret);
        }
        throw new NoAliyunCredentialsException("SimpleAliyunCredentialsProvider", "No Aliyun credentials in the configuration");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

