/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AbstractSessionCredentialsProvider;
import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.MarshalledCredentialBinding;
import com.aliyun.emr.fs.auth.MarshalledCredentials;
import com.aliyun.emr.fs.auth.NoAliyunCredentialsException;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TemporaryAliyunCredentialsProvider
extends AbstractSessionCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.auth.TemporaryAliyunCredentialsProvider";
    public static final String COMPONENT = "Session credentials in Hadoop configuration";

    public TemporaryAliyunCredentialsProvider(Configuration conf, AliyunCredentialsProvider.CredentialType type) {
        this(null, conf, type);
    }

    public TemporaryAliyunCredentialsProvider(@Nullable URI uri, Configuration conf, AliyunCredentialsProvider.CredentialType type) {
        super(uri, conf, type);
    }

    @Override
    protected AliyunCredentials createCredentials(Configuration config) throws IOException {
        MarshalledCredentials creds;
        if (this.getType() == AliyunCredentialsProvider.CredentialType.OSS) {
            creds = MarshalledCredentialBinding.fromFileSystem(this.getUri(), config, AbstractJindoShimsFileSystem.class);
        } else if (this.getType() == AliyunCredentialsProvider.CredentialType.OTS) {
            creds = new MarshalledCredentials(AuthUtils.getPassword(config, "fs.jfs.cache.ots.accessKeyId", null, ""), AuthUtils.getPassword(config, "fs.jfs.cache.ots.accessKeySecret", null, ""), AuthUtils.getPassword(config, "fs.jfs.cache.ots.securityToken", null, ""));
        } else if (this.getType() == AliyunCredentialsProvider.CredentialType.JFS) {
            creds = new MarshalledCredentials(AuthUtils.getPassword(config, "fs.jfs.accessKeyId", null, ""), AuthUtils.getPassword(config, "fs.jfs.accessKeySecret", null, ""), AuthUtils.getPassword(config, "fs.jfs.securityToken", null, ""));
        } else {
            throw new IOException("WARNING: wrong credential type: " + this.getType().name());
        }
        MarshalledCredentials.CredentialTypeRequired sessionOnly = MarshalledCredentials.CredentialTypeRequired.SessionOnly;
        if (!creds.isValid(sessionOnly)) {
            throw new NoAliyunCredentialsException(COMPONENT);
        }
        return MarshalledCredentialBinding.toAliyunCredentials(creds, sessionOnly, COMPONENT);
    }
}

