/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth.delegation;

import com.aliyun.emr.fs.auth.delegation.DelegationTokenIOException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;

public abstract class AbstractOssTokenIdentifier
extends DelegationTokenIdentifier {
    protected static final int MAX_TEXT_LENGTH = 8192;
    private URI uri;
    private long created = System.currentTimeMillis();
    private String origin = "";
    private String uuid = UUID.randomUUID().toString();

    protected AbstractOssTokenIdentifier(Text kind, URI uri, Text owner, Text renewer, String origin) {
        this(kind, owner, renewer != null ? renewer : new Text(), new Text(), uri);
        this.origin = Objects.requireNonNull(origin);
    }

    protected AbstractOssTokenIdentifier(Text kind, Text owner, Text renewer, Text realUser, URI uri) {
        super(kind, owner, renewer, realUser);
        this.uri = Objects.requireNonNull(uri);
    }

    protected AbstractOssTokenIdentifier(Text kind, Token<AbstractOssTokenIdentifier> token) throws IOException {
        super(kind);
        ByteArrayInputStream bais = new ByteArrayInputStream(token.getIdentifier());
        this.readFields(new DataInputStream(bais));
    }

    protected AbstractOssTokenIdentifier(Text kind) {
        super(kind);
    }

    public String getBucket() {
        return this.uri.getHost();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public long getCreated() {
        return this.created;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.uri.toString());
        Text.writeString((DataOutput)out, (String)this.origin);
        Text.writeString((DataOutput)out, (String)this.uuid);
        out.writeLong(this.created);
    }

    public void readFields(DataInput in) throws DelegationTokenIOException, IOException {
        super.readFields(in);
        this.uri = URI.create(Text.readString((DataInput)in, (int)8192));
        this.origin = Text.readString((DataInput)in, (int)8192);
        this.uuid = Text.readString((DataInput)in, (int)8192);
        this.created = in.readLong();
    }

    public void validate() throws IOException {
        if (this.uri == null) {
            throw new DelegationTokenIOException("No URI in " + (Object)((Object)this));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OssTokenIdentifier{");
        sb.append(this.getKind());
        sb.append("; uri=").append(this.uri);
        sb.append("; timestamp=").append(this.created);
        sb.append("; renewer=").append(this.getRenewer());
        sb.append("; ").append(this.uuid);
        sb.append("; ").append(this.origin);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractOssTokenIdentifier that = (AbstractOssTokenIdentifier)((Object)o);
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uri);
    }

    public long getExpiryTime() {
        return 0L;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static String createDefaultOriginMessage() {
        return String.format("Created on %s at time %s.", NetUtils.getHostname(), Instant.now());
    }
}

