/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.bench;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallFileCompactionTest {
    static final Logger LOG = LoggerFactory.getLogger(SmallFileCompactionTest.class);
    private Path testDir;
    private URI uri;
    private FileSystem fs;
    private Configuration conf;
    private boolean needFlush = false;
    private byte[][] data;
    private static final String BASE_DIR = "compacttest";
    boolean failed = false;

    public SmallFileCompactionTest(URI uri, boolean needFlush, Configuration conf) throws IOException {
        this.uri = uri;
        this.conf = conf;
        this.needFlush = needFlush;
        try {
            this.fs = FileSystem.get((URI)this.uri, (Configuration)this.conf);
        }
        catch (IOException e) {
            LOG.error("Cannot init file system " + uri);
            throw e;
        }
        String path = uri.getRawPath().endsWith("/") ? uri.toString() + BASE_DIR : uri.toString() + "/" + BASE_DIR;
        path = path + System.currentTimeMillis();
        this.testDir = new Path(path);
        System.out.println("Test path " + this.testDir.toString());
    }

    private static void printHelp() {
        String usage = "Usage: " + SmallFileCompactionTest.class.getSimpleName() + " -files fileNumber";
        System.out.println(usage);
    }

    public void run() throws Exception {
        this.prepareData();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            System.out.println("========Start " + i + " round=======");
            this.write(i);
            if (this.failed) {
                LOG.error("Write failed!!!");
                break;
            }
            this.read(i);
            if (this.failed) {
                LOG.error("Read failed!!!");
                break;
            }
            System.out.println("<<<<<<<End " + i + " round>>>>>>");
            Thread.sleep(10000L);
        }
    }

    private void prepareData() {
        this.data = new byte[10][0x800000];
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            rand.nextBytes(this.data[i]);
        }
    }

    private void write(final int round) throws Exception {
        System.out.println("Start write");
        ExecutorService executors = Executors.newFixedThreadPool(20);
        int i = 0;
        while (i < 100) {
            final int index = i++;
            executors.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SmallFileCompactionTest.this.needFlush) {
                            SmallFileCompactionTest.this.writeWithFlush(round, index);
                        } else {
                            SmallFileCompactionTest.this.writeWithoutFlush(round, index);
                        }
                    }
                    catch (Exception e) {
                        SmallFileCompactionTest.this.failed = true;
                        e.printStackTrace();
                    }
                }
            });
        }
        executors.shutdown();
        executors.awaitTermination(10L, TimeUnit.MINUTES);
    }

    private void writeWithFlush(int round, int index) throws Exception {
        String fileName = "file_" + round + "_" + index;
        Path filePath = new Path(this.testDir, fileName + "_8M");
        FSDataOutputStream out = this.fs.create(filePath);
        int fileLen = SmallFileCompactionTest.getLength8M(index);
        int startOffset = SmallFileCompactionTest.getOffset(index);
        int length = 0;
        int offset = 0;
        int flushCnt = 0;
        while (flushCnt < 2) {
            length = 0x200000 + index + flushCnt * 73;
            out.write(this.data[round % 10], startOffset + offset, length);
            out.flush();
            ++flushCnt;
            offset += length;
        }
        out.write(this.data[round % 10], startOffset + offset, fileLen - offset);
        out.close();
        filePath = new Path(this.testDir, fileName + "_4M");
        out = this.fs.create(filePath);
        startOffset = SmallFileCompactionTest.getOffset(index);
        fileLen = SmallFileCompactionTest.getLength4M(index);
        out.write(this.data[round % 10], startOffset, 0x100000 + index * 13);
        offset = 0x100000 + index * 13;
        out.flush();
        out.write(this.data[round % 10], startOffset + offset, fileLen - offset);
        out.close();
        filePath = new Path(this.testDir, fileName + "_2M");
        out = this.fs.create(filePath);
        out.write(this.data[round % 10], SmallFileCompactionTest.getOffset(index), SmallFileCompactionTest.getLength2M(index));
        out.flush();
        out.close();
    }

    private void writeWithoutFlush(int round, int index) throws Exception {
        String fileName = "file_" + round + "_" + index;
        Path filePath = new Path(this.testDir, fileName + "_8M");
        FSDataOutputStream out = this.fs.create(filePath);
        out.write(this.data[round % 10], SmallFileCompactionTest.getOffset(index), SmallFileCompactionTest.getLength8M(index));
        out.close();
        filePath = new Path(this.testDir, fileName + "_4M");
        out = this.fs.create(filePath);
        out.write(this.data[round % 10], SmallFileCompactionTest.getOffset(index), SmallFileCompactionTest.getLength4M(index));
        out.close();
        filePath = new Path(this.testDir, fileName + "_2M");
        out = this.fs.create(filePath);
        out.write(this.data[round % 10], SmallFileCompactionTest.getOffset(index), SmallFileCompactionTest.getLength2M(index));
        out.close();
    }

    private void read(int round) throws Exception {
        System.out.println("Start read");
        for (int roundIndex = 0; roundIndex <= round; ++roundIndex) {
            final int currentRound = roundIndex;
            ExecutorService executors = Executors.newFixedThreadPool(20);
            for (int i = 0; i < 100; ++i) {
                final int index = i;
                final String fileName = "file_" + currentRound + "_" + i;
                executors.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Path filePath = new Path(SmallFileCompactionTest.this.testDir, fileName + "_8M");
                            FileStatus fileStatus = SmallFileCompactionTest.this.fs.getFileStatus(filePath);
                            int size = (int)fileStatus.getLen();
                            FSDataInputStream in = SmallFileCompactionTest.this.fs.open(filePath);
                            byte[] buf = new byte[size];
                            in.readFully(buf);
                            if (!SmallFileCompactionTest.compareData(buf, SmallFileCompactionTest.this.data[currentRound % 10], SmallFileCompactionTest.getOffset(index), SmallFileCompactionTest.getLength8M(index))) {
                                System.err.println("Data corrupted for file " + filePath);
                                SmallFileCompactionTest.this.failed = true;
                                return;
                            }
                            in.close();
                            filePath = new Path(SmallFileCompactionTest.this.testDir, fileName + "_4M");
                            fileStatus = SmallFileCompactionTest.this.fs.getFileStatus(filePath);
                            size = (int)fileStatus.getLen();
                            in = SmallFileCompactionTest.this.fs.open(filePath);
                            buf = new byte[size];
                            in.readFully(buf);
                            if (!SmallFileCompactionTest.compareData(buf, SmallFileCompactionTest.this.data[currentRound % 10], SmallFileCompactionTest.getOffset(index), SmallFileCompactionTest.getLength4M(index))) {
                                System.err.println("Data corrupted for file " + filePath);
                                SmallFileCompactionTest.this.failed = true;
                                return;
                            }
                            in.close();
                            filePath = new Path(SmallFileCompactionTest.this.testDir, fileName + "_2M");
                            fileStatus = SmallFileCompactionTest.this.fs.getFileStatus(filePath);
                            size = (int)fileStatus.getLen();
                            in = SmallFileCompactionTest.this.fs.open(filePath);
                            buf = new byte[size];
                            in.readFully(buf);
                            if (!SmallFileCompactionTest.compareData(buf, SmallFileCompactionTest.this.data[currentRound % 10], SmallFileCompactionTest.getOffset(index), SmallFileCompactionTest.getLength2M(index))) {
                                System.err.println("Data corrupted for file " + filePath);
                                SmallFileCompactionTest.this.failed = true;
                                return;
                            }
                            in.close();
                        }
                        catch (Exception e) {
                            SmallFileCompactionTest.this.failed = true;
                            e.printStackTrace();
                        }
                    }
                });
            }
            executors.shutdown();
            executors.awaitTermination(10L, TimeUnit.MINUTES);
        }
    }

    static int getOffset(int index) {
        return index % 284;
    }

    static int getLength8M(int index) {
        return 0x600000 + index % 577;
    }

    static int getLength4M(int index) {
        return 0x300000 + index % 339;
    }

    static int getLength2M(int index) {
        return 0x100000 + index % 768;
    }

    static boolean compareData(byte[] buf, byte[] expected, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (buf[i] == expected[offset + i]) continue;
            System.err.println("Error when reading " + i + " byte, expected " + expected[offset + i] + ", actual " + buf[i]);
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        this.fs.close();
    }

    private static int parseFiles(String arg) {
        int files = Integer.parseInt(arg);
        if (files < 1) {
            files = 1;
        }
        return files;
    }

    public static void main(String[] argv) throws Exception {
        String fsUriStr = null;
        boolean needFlush = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-fs")) {
                fsUriStr = argv[++i];
                continue;
            }
            if (argv[i].startsWith("-flush")) {
                needFlush = true;
                continue;
            }
            if (argv[i].startsWith("--help") || argv[i].startsWith("-h")) {
                SmallFileCompactionTest.printHelp();
                return;
            }
            System.err.println("Illegal argument " + argv[i]);
            return;
        }
        if (fsUriStr == null) {
            SmallFileCompactionTest.printHelp();
            System.err.println("please specify test filesystem with -fs");
            return;
        }
        URI fsUri = null;
        try {
            fsUri = new URI(fsUriStr);
        }
        catch (Exception e) {
            System.err.println("Not a valid fs URI " + fsUriStr);
            return;
        }
        Configuration conf = new Configuration();
        SmallFileCompactionTest tool = new SmallFileCompactionTest(fsUri, needFlush, conf);
        tool.run();
        tool.close();
    }
}

