/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.common;

import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsStats {
    private static final Logger LOG = LoggerFactory.getLogger(FsStats.class);

    public static void logStats(String cmd, Path path, String parameter) {
        LOG.info("cmd={}, path={}, parameter={}", new Object[]{cmd, FsStats.printOssPath(path), parameter});
    }

    public static void logStats(String cmd, Path src, Path dst, long size, String parameter, long timeInNs, String version) {
        LOG.info("cmd={}, src={}, dst={}, size={}, parameter={}, time-in-ms={}, version={}", new Object[]{cmd, FsStats.printOssPath(src), FsStats.printOssPath(dst), size, parameter, timeInNs / 1000000L, version});
    }

    public static void logStats(String cmd, String src, String dst, long size, String parameter, long timeInNs, String version) {
        LOG.info("cmd={}, src={}, dst={}, size={}, parameter={}, time-in-ms={}, version={}", new Object[]{cmd, src, dst, size, parameter, timeInNs / 1000000L, version});
    }

    public static String printOssPath(Path path) {
        if (path == null) {
            return null;
        }
        URI uri = path.toUri();
        LOG.debug("path: " + path + ", uri: " + uri + ", schema :" + uri.getScheme() + ", authority: " + uri.getAuthority() + ", host: " + uri.getHost());
        if (uri.getScheme() != null) {
            if (uri.getHost() != null) {
                return uri.getScheme() + "://" + uri.getHost() + uri.getPath();
            }
            String host = uri.getAuthority();
            try {
                int offset = uri.getAuthority().indexOf("@");
                host = offset > 0 ? uri.getAuthority().substring(offset + 1) : uri.getAuthority();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return uri.getScheme() + "://" + host + uri.getPath();
        }
        return uri.getPath();
    }
}

