/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.common;

import com.aliyun.emr.fs.common.AbstractJindoCommitterFactory;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;

public class JindoCommitter
extends FileOutputCommitter {
    private final FileOutputCommitter wrapped;

    public JindoCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        if (outputPath == null) {
            this.wrapped = new FileOutputCommitter(null, context);
            return;
        }
        FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
        if (fs instanceof AbstractJindoShimsFileSystem) {
            AbstractJindoCommitterFactory factory = ((AbstractJindoShimsFileSystem)fs).createFileOutputCommitterFactory();
            this.wrapped = factory.createFileOutputCommitter(outputPath, context);
        } else {
            this.wrapped = new FileOutputCommitter(outputPath, context);
        }
    }

    public JindoCommitter(Path outputPath, JobContext context) throws IOException {
        super(outputPath, context);
        if (outputPath == null) {
            this.wrapped = new FileOutputCommitter(null, context);
            return;
        }
        FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
        if (fs instanceof AbstractJindoShimsFileSystem) {
            AbstractJindoCommitterFactory factory = ((AbstractJindoShimsFileSystem)fs).createFileOutputCommitterFactory();
            this.wrapped = factory.createFileOutputCommitter(outputPath, context);
        } else {
            this.wrapped = new FileOutputCommitter(outputPath, context);
        }
    }

    public void setupJob(JobContext jobContext) throws IOException {
        this.wrapped.setupJob(jobContext);
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        this.wrapped.abortJob(jobContext, state);
    }

    public void cleanupJob(JobContext jobContext) throws IOException {
        this.wrapped.cleanupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        this.wrapped.commitJob(jobContext);
    }

    public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.wrapped.setupTask(taskAttemptContext);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
        return this.wrapped.needsTaskCommit(taskAttemptContext);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext, Path taskAttemptPath) throws IOException {
        return this.wrapped.needsTaskCommit(taskAttemptContext, taskAttemptPath);
    }

    public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.wrapped.commitTask(taskAttemptContext);
    }

    public void commitTask(TaskAttemptContext taskAttemptContext, Path taskAttemptPath) throws IOException {
        this.wrapped.commitTask(taskAttemptContext, taskAttemptPath);
    }

    public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.wrapped.abortTask(taskAttemptContext);
    }

    public void abortTask(TaskAttemptContext taskAttemptContext, Path taskAttemptPath) throws IOException {
        this.wrapped.abortTask(taskAttemptContext, taskAttemptPath);
    }

    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        this.wrapped.recoverTask(taskContext);
    }

    public boolean isRecoverySupported() {
        return this.wrapped.isRecoverySupported();
    }

    public boolean isRecoverySupported(JobContext jobContext) throws IOException {
        return this.wrapped.isRecoverySupported(jobContext);
    }

    public boolean isCommitJobRepeatable(JobContext jobContext) throws IOException {
        return this.wrapped.isCommitJobRepeatable(jobContext);
    }

    public Path getWorkPath() throws IOException {
        return this.wrapped.getWorkPath();
    }

    public FileOutputCommitter getRealCommitter() {
        return this.wrapped;
    }
}

