/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal;

import bigboot.protocol.type.CltArchiveDirReply;
import bigboot.protocol.type.CltRecoverReply;
import bigboot.protocol.type.CltRestoreDirReply;
import bigboot.protocol.type.CltUnarchiveDirReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.NssFileletDiffReply;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.internal.JindoCryptoPolicy;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public abstract class AbstractFileSystemStore {
    protected Configuration conf;
    protected FileSystem fs;
    protected static final int BLOCKLET_SIZE = 0x800000;
    private Context context;

    public AbstractFileSystemStore(FileSystem fs, Configuration conf, Context context) {
        this.fs = fs;
        this.conf = conf;
        this.context = context;
    }

    protected int allignBufferSize(int bufferSize) {
        if (bufferSize > 0x800000) {
            bufferSize = 0x800000;
        } else if (bufferSize < 65536) {
            bufferSize = 65536;
        } else if (0x800000 % bufferSize != 0) {
            int exp = (int)(Math.log(bufferSize) / Math.log(2.0));
            bufferSize = 1 << exp;
        }
        return bufferSize;
    }

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public abstract FSDataOutputStream create(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8, String var9) throws IOException;

    public FSDataOutputStream create(Path qualifiedPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption, String checksumInfo) throws IOException {
        return this.create(qualifiedPath, permission, overwrite, bufferSize, replication, blockSize, progress, storageOption);
    }

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    public abstract boolean rename(Path var1, Path var2, boolean var3, boolean var4) throws IOException;

    public abstract boolean delete(Path var1, boolean var2, boolean var3, boolean var4) throws IOException;

    public abstract FileStatus[] listStatus(Path var1, boolean var2, boolean var3) throws IOException;

    public abstract RemoteIterator<LocatedFileStatus> listLocatedStatus(Path var1, PathFilter var2) throws IOException;

    public abstract boolean mkdirs(Path var1, FsPermission var2) throws IOException;

    public abstract BlockLocation[] getFileBlockLocations(FileStatus var1, long var2, long var4) throws IOException;

    public abstract byte[] getXAttr(Path var1, String var2) throws IOException;

    public abstract Map<String, byte[]> getXAttrs(Path var1) throws IOException;

    public abstract Map<String, byte[]> getXAttrs(Path var1, List<String> var2) throws IOException;

    public abstract void setXAttr(Path var1, String var2, byte[] var3) throws IOException;

    public abstract List<String> listXAttrs(Path var1) throws IOException;

    public abstract void removeXAttr(Path var1, String var2) throws IOException;

    public abstract void checkPermission(Path var1, FsAction var2) throws IOException;

    public abstract void setPermission(Path var1, FsPermission var2) throws IOException;

    public abstract void processPermissionDelta(Path var1, short var2, short var3, boolean var4) throws IOException;

    public abstract void setOwner(Path var1, String var2, String var3, boolean var4) throws IOException;

    public abstract void setOwner(Path var1, String var2, String var3) throws IOException;

    public abstract ContentSummary getContentSummary(Path var1) throws IOException;

    public abstract FileChecksum getFileChecksum(Path var1) throws IOException;

    public abstract FileChecksum getFileChecksum2(Path var1) throws IOException;

    public abstract FileChecksum getFileChecksum2(Path var1, long var2) throws IOException;

    public void close() throws IOException {
    }

    public void setStatistics(FileSystem.Statistics statistics) {
        this.context.statistics = statistics;
    }

    public abstract Boolean isMagicCommitEnabled();

    public abstract void uncache(Path var1) throws IOException;

    public abstract void cache(Path var1, AbstractJindoShimsFileSystem.CacheOpContext var2) throws IOException;

    public abstract void archive(Path var1, Byte var2) throws IOException;

    public abstract void unarchive(Path var1, Byte var2) throws IOException;

    public abstract FileletStatus[] checkProgress(Path var1, boolean var2) throws IOException;

    public void atomicCache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        throw new UnsupportedOperationException("Atomic cache not supported");
    }

    public NssFileletDiffReply metaDiff(Path path, boolean recursiave) throws IOException {
        throw new UnsupportedOperationException("Meta diff not supported");
    }

    public void metaSync(Path path, boolean recursiave, boolean progressable) throws IOException {
        throw new UnsupportedOperationException("Meta sync not supported");
    }

    public void setCryptoPolicy(Path path, String keyIdName, byte cipherSuite) throws IOException {
        throw new UnsupportedOperationException("Set crypto policy not supported");
    }

    public JindoCryptoPolicy getCryptoPolicy(Path path) throws IOException {
        throw new UnsupportedOperationException("Get crypto policy not supported");
    }

    public CltRecoverReply recoverCore(Path path, boolean recursive) throws IOException {
        throw new UnsupportedOperationException("Recover not supported");
    }

    public abstract CltArchiveDirReply archiveDir(Path var1, Byte var2) throws IOException;

    public abstract CltUnarchiveDirReply unarchiveDir(Path var1, Byte var2) throws IOException;

    public abstract CltRestoreDirReply restoreDir(Path var1) throws IOException;

    public static class Context {
        public URI uri;
        public Path workingDir;
        public FileSystem.Statistics statistics;
        public String logName;
    }
}

