/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal;

import com.aliyun.emr.fs.common.FsStats;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferPositionedReadable;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JindoInputStream
extends FSInputStream
implements ByteBufferReadable,
ByteBufferPositionedReadable {
    static final Logger LOG = LoggerFactory.getLogger(JindoInputStream.class);
    protected final ReadContext context;
    protected byte[] oneByteBuf = new byte[1];
    protected long currentBufferId = -1L;
    protected boolean closed = false;
    protected ByteBuffer buffer;
    protected long byteReaded = 0L;
    protected long byteNeeded = 0L;
    protected int readTimes = 0;
    protected long readElapsedNanos = 0L;

    public JindoInputStream(ReadContext context) {
        context.tid = Thread.currentThread().getId();
        this.context = context;
        this.buffer = ByteBuffer.allocate(0);
    }

    public synchronized int read() throws IOException {
        int n;
        while ((n = this.read(this.oneByteBuf, 0, 1)) == 0) {
        }
        if (this.context.stats != null && n >= 0) {
            this.context.stats.incrementBytesRead(1L);
        }
        return n == -1 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    public synchronized int read(byte[] buff, int off, int len) throws IOException {
        ArrayBufferStrategy reader = new ArrayBufferStrategy(buff, off, len);
        int byteRead = reader.readBuffer();
        if (this.context.stats != null && byteRead >= 0) {
            this.context.stats.incrementBytesRead((long)byteRead);
        }
        this.byteNeeded += (long)byteRead;
        ++this.readTimes;
        return byteRead;
    }

    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        ByteBufferStrategy reader = new ByteBufferStrategy(byteBuffer);
        int byteRead = reader.readBuffer();
        if (this.context.stats != null && byteRead >= 0) {
            this.context.stats.incrementBytesRead((long)byteRead);
        }
        this.byteNeeded += (long)byteRead;
        ++this.readTimes;
        return byteRead;
    }

    protected abstract int bufferMore() throws IOException;

    public abstract int readFromPostion(long var1, byte[] var3, int var4, int var5) throws IOException;

    public abstract int readFromPostion(long var1, ByteBuffer var3, int var4) throws IOException;

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.validatePositionedReadArgs(position, buffer, offset, length);
        int actualLen = this.getActualPositionedReadLength(position, length);
        if (actualLen <= 0) {
            return actualLen;
        }
        int read = this.readFromPostion(position, buffer, offset, actualLen);
        if (this.context.stats != null) {
            this.context.stats.incrementReadOps(1);
        }
        return read;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int nread;
        int nbytes;
        this.validatePositionedReadArgs(position, buffer, offset, length);
        int actualLen = this.getActualPositionedReadLength(position, length);
        if (actualLen < length) {
            throw new EOFException("End of file reached before reading fully.");
        }
        if (actualLen == 0) {
            return;
        }
        for (nread = 0; nread < length; nread += nbytes) {
            nbytes = this.readFromPostion(position + (long)nread, buffer, offset + nread, length - nread);
            if (nbytes >= 0) continue;
            throw new EOFException("End of file reached before reading fully.");
        }
        if (this.context.stats != null) {
            this.context.stats.incrementReadOps(1);
            this.context.stats.incrementBytesRead((long)nread);
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public synchronized long getPos() throws IOException {
        this.checkStream();
        return this.currentBufferId < 0L ? (long)this.buffer.position() : this.currentBufferId * (long)this.context.bufferSize + (long)this.buffer.position();
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized void seek(long newPos) throws IOException {
        this.checkStream();
        if (newPos < 0L) {
            throw new EOFException("Cannot seek to a negative offset: Pos = " + newPos);
        }
        if (newPos > this.context.fileSize) {
            throw new EOFException("Attempted to seek or read past the end of the file: Pos = " + newPos + ", File Size = " + this.context.fileSize);
        }
        LOG.debug("InputStream seek newPos/getPos(): " + newPos + "/" + this.getPos());
        if (this.getPos() != newPos) {
            int newBufferId = (int)(newPos / (long)this.context.bufferSize);
            long newOffset = newPos % (long)this.context.bufferSize;
            if ((long)newBufferId != this.currentBufferId) {
                this.currentBufferId = newBufferId;
                --this.currentBufferId;
                LOG.debug("InputStream newOffset/currentBufferId: " + newOffset + "/" + this.currentBufferId);
                if (this.bufferMore() < 0) {
                    newOffset = this.context.bufferSize;
                }
            }
            LOG.debug("readBuffer.smartBuffer() pos/limit: " + this.buffer.position() + "/" + this.buffer.limit());
            try {
                this.buffer.position((int)newOffset);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Buffer error: buffer position {}, limit {}, new offset {}, file offset {}, file size {}, buffer @ {}, path {}", new Object[]{this.buffer.position(), this.buffer.limit(), newOffset, newPos, this.context.fileSize, System.identityHashCode(this.buffer), this.context.path});
                throw e;
            }
        }
    }

    public synchronized int available() throws IOException {
        this.checkStream();
        return (int)(this.context.fileSize - this.getPos());
    }

    public synchronized long skip(long n) throws IOException {
        this.checkStream();
        if (n <= 0L) {
            return 0L;
        }
        if (this.getPos() + n < this.context.fileSize) {
            this.seek(this.getPos() + n);
            return n;
        }
        long curPos = this.getPos();
        this.seek(this.context.fileSize);
        return this.context.fileSize - curPos;
    }

    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void close() throws IOException {
        super.close();
        FsStats.logStats("download", this.context.path, null, this.context.fileSize, "byteReaded:" + this.byteReaded + ",byteNeeded:" + this.byteNeeded + ",readTimes:" + this.readTimes, this.readElapsedNanos, "3.7.2");
    }

    protected void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    protected void validatePositionedReadArgs(long position, byte[] buffer, int offset, int length) throws EOFException {
        Preconditions.checkArgument(length >= 0, "length is negative");
        if (position < 0L) {
            throw new EOFException("position is negative");
        }
        Preconditions.checkArgument(buffer != null, "Null buffer");
        if (buffer.length - offset < length) {
            throw new IndexOutOfBoundsException("Requested more bytes than destination buffer size: request length=" + length + ", with offset =" + offset + "; buffer capacity =" + (buffer.length - offset));
        }
    }

    private int getActualPositionedReadLength(long position, int length) {
        if (length == 0) {
            return 0;
        }
        long remaining = this.context.fileSize - position;
        if (remaining <= 0L) {
            return -1;
        }
        if ((long)length <= remaining) {
            return length;
        }
        return (int)remaining;
    }

    @Override
    public int read(long position, ByteBuffer byteBuffer) throws IOException {
        Preconditions.checkArgument(byteBuffer != null, "Null buffer");
        if (position < 0L) {
            throw new EOFException("position is negative");
        }
        if (position >= this.context.fileSize) {
            return -1;
        }
        int length = byteBuffer.limit() - byteBuffer.position();
        if (length == 0) {
            return 0;
        }
        long remainingLength = this.context.fileSize - position;
        int actualLength = remainingLength < (long)length ? (int)remainingLength : length;
        int read = this.readFromPostion(position, byteBuffer, actualLength);
        if (this.context.stats != null && read > 0) {
            this.context.stats.incrementReadOps(1);
            this.context.stats.incrementBytesRead((long)read);
        }
        return read;
    }

    private boolean validatePositionedReadArgsForByteBuffer(long position, ByteBuffer byteBuffer, int length) throws EOFException {
        Preconditions.checkArgument(byteBuffer != null, "Null buffer");
        if (position < 0L) {
            throw new EOFException("position is negative");
        }
        int actualLen = this.getActualPositionedReadLength(position, length);
        if (actualLen < length) {
            throw new EOFException("End of file reached before reading fully.");
        }
        return actualLen != 0;
    }

    @Override
    public void readFully(long position, ByteBuffer byteBuffer) throws IOException {
        int nbytes;
        int length = byteBuffer.limit() - byteBuffer.position();
        if (!this.validatePositionedReadArgsForByteBuffer(position, byteBuffer, length)) {
            return;
        }
        for (int nread = 0; nread < length; nread += nbytes) {
            nbytes = this.readFromPostion(position + (long)nread, byteBuffer, length - nread);
            if (nbytes >= 0) continue;
            throw new EOFException("End of file reached before reading fully.");
        }
        if (this.context.stats != null) {
            this.context.stats.incrementReadOps(1);
        }
    }

    private class ArrayBufferStrategy
    implements ReaderStrategy {
        private byte[] buf;
        private int off;
        private int len;

        ArrayBufferStrategy(byte[] buf, int off, int len) {
            this.buf = buf;
            this.off = off;
            this.len = len;
        }

        @Override
        public int readBuffer() throws IOException {
            int ret;
            JindoInputStream.this.checkStream();
            if (this.buf == null) {
                throw new NullPointerException("Input buffer is null");
            }
            if (this.off < 0 || this.len < 0 || this.len > this.buf.length - this.off) {
                throw new IndexOutOfBoundsException();
            }
            if (this.len == 0) {
                return 0;
            }
            int remaining = JindoInputStream.this.buffer.remaining();
            if (remaining <= 0 && ((ret = JindoInputStream.this.bufferMore()) == 0 || ret == -1)) {
                return ret;
            }
            int n = Math.min(this.len, JindoInputStream.this.buffer.remaining());
            JindoInputStream.this.buffer.get(this.buf, this.off, n);
            return n;
        }
    }

    private class ByteBufferStrategy
    implements ReaderStrategy {
        private ByteBuffer buf;

        ByteBufferStrategy(ByteBuffer buf) {
            this.buf = buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int readBuffer() throws IOException {
            JindoInputStream.this.checkStream();
            if (this.buf == null) {
                throw new NullPointerException("Input buffer is null");
            }
            int oldpos = this.buf.position();
            int oldlimit = this.buf.limit();
            boolean success = false;
            try {
                int ret;
                int remaining = JindoInputStream.this.buffer.remaining();
                if (remaining <= 0 && ((ret = JindoInputStream.this.bufferMore()) == 0 || ret == -1)) {
                    int n = ret;
                    return n;
                }
                int n = Math.min(this.buf.remaining(), JindoInputStream.this.buffer.remaining());
                for (int i = 0; i < n; ++i) {
                    this.buf.put(JindoInputStream.this.buffer.get());
                }
                success = true;
                int n2 = n;
                return n2;
            }
            finally {
                if (!success) {
                    this.buf.position(oldpos);
                    this.buf.limit(oldlimit);
                }
            }
        }
    }

    static interface ReaderStrategy {
        public int readBuffer() throws IOException;
    }

    public static abstract class ReadContext {
        public Path path;
        public long fileSize;
        public int bufferSize;
        public long totalBuffers;
        public FileSystem.Statistics stats;
        public long tid;
        public int timeoutInSecond;
    }
}

