/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.hdfs;

import bigboot.protocol.type.FileletStatus;

public class HdfsFileMeta {
    private final String key;
    private final long length;
    private final long lastModified;
    private final String eTag;

    public HdfsFileMeta(String key, long length, long lastModified, String eTag) {
        this.key = key;
        this.length = length;
        this.lastModified = lastModified;
        this.eTag = eTag;
    }

    public HdfsFileMeta(FileletStatus status) {
        this.key = status.inodeAsInodeStatus().fileName();
        this.length = status.inodeAsInodeStatus().fileSize();
        this.lastModified = status.inodeAsInodeStatus().mtime();
        this.eTag = status.inodeAsInodeStatus().etag();
    }

    public String getKey() {
        return this.key;
    }

    public long getLength() {
        return this.length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String geteTag() {
        return this.eTag;
    }

    public String toString() {
        return "OssFileMeta[" + this.key + ", " + this.length + ", " + this.lastModified + ", " + this.eTag + "]";
    }
}

