/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.hdfs;

import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.InodeStatus;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.internal.hdfs.HdfsFileStatus;
import com.aliyun.emr.fs.internal.hdfs.HdfsOpContext;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsGetFileStatusOp {
    private final HdfsOpContext context;
    private final FileSystem fs;
    private final CredentialContext ossContext;

    public HdfsGetFileStatusOp(HdfsOpContext context, FileSystem fs, CredentialContext ossContext) {
        this.context = context;
        this.fs = fs;
        this.ossContext = ossContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdfsFileStatus getFileStatus(Path f, boolean lsExtend) throws IOException {
        Table reply = null;
        try {
            HdfsFileStatus status;
            reply = this.context.hdfsFileletSystem.getStatus(new JindoRequestPath(f.toString(), this.ossContext), lsExtend);
            InodeStatus inodeStatus = ((FileletStatus)reply).inodeAsInodeStatus();
            HdfsFileStatus hdfsFileStatus = status = new HdfsFileStatus(inodeStatus, this.fs.getConf());
            return hdfsFileStatus;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }
}

