/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import bigboot.protocol.type.NamespaceInfo;
import com.alibaba.jfs.CredentialContext;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.internal.jfs.JfsFileletSystem;
import com.aliyun.emr.fs.internal.ossnative.OssCredentialUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JfsCredentialUtils
extends OssCredentialUtils {
    public static final Logger LOG = LoggerFactory.getLogger(JfsCredentialUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CredentialContext obtainOssCredentialContext(String path, Configuration configuration) throws IOException {
        if (cachedCredentialContext != null) return cachedCredentialContext;
        Class<OssCredentialUtils> clazz = OssCredentialUtils.class;
        synchronized (OssCredentialUtils.class) {
            if (cachedCredentialContext != null) return cachedCredentialContext;
            URI uri = URI.create(path);
            if (uri.getScheme().equalsIgnoreCase("jfs")) {
                JfsFileletSystem fileletSystem = new JfsFileletSystem();
                NamespaceInfo namespaceInfo = fileletSystem.getNamespaceInfo(uri.getAuthority());
                cachedCredentialContext = namespaceInfo.mode() == 1 ? JfsCredentialUtils.createCredentialContext(path, configuration, AliyunCredentialsProvider.CredentialType.JFS) : JfsCredentialUtils.createCredentialContext(path, configuration, AliyunCredentialsProvider.CredentialType.OSS);
            } else {
                if (!uri.getScheme().equalsIgnoreCase("oss") && !uri.getScheme().equalsIgnoreCase("hdfs")) return cachedCredentialContext;
                cachedCredentialContext = JfsCredentialUtils.createCredentialContext(path, configuration, AliyunCredentialsProvider.CredentialType.OSS);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cachedCredentialContext;
        }
    }
}

