/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletXattributeList;
import bigboot.protocol.type.FsState;
import bigboot.protocol.type.InodeStatus;
import bigboot.protocol.type.StoragePolicy;
import bigboot.protocol.type.Xattribute;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.aliyun.emr.fs.jfs.Constants;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;

public class JfsFileStatus
extends FileStatus {
    static FsPermission nullPermission = null;
    private String jindoINodeId;
    private Map<String, String> attrs;
    String storageClass;
    String state;

    public JfsFileStatus(InodeStatus s, FileSystem fs, Configuration conf) {
        super(s.fileSize(), 0 == s.fileType(), JfsFileStatus.getReplication(s.storagePolicy()), conf.getLong("fs.jfs.blocksize", Constants.FS_JFS_BLOCKSIZE_DEFAULT), s.mtime(), System.currentTimeMillis(), new FsPermission(s.permission()), s.owner(), s.ownerGroup(), null, new Path(s.fileName()).makeQualified(fs));
        this.jindoINodeId = s.fileId() == null ? "" : s.fileId();
        this.storageClass = this.convertJfsStorageClass(s.storagePolicy());
        this.state = this.convertJfsState(s.state());
    }

    private static int getReplication(byte b) {
        return 1;
    }

    private JfsFileStatus(long length, boolean isDir, short replication, Configuration conf) {
        super(length, isDir, (int)replication, conf.getLong("fs.jfs.blocksize", Constants.FS_JFS_BLOCKSIZE_DEFAULT), System.currentTimeMillis(), 0L, null, null, null, null);
    }

    public static JfsFileStatus createStatus(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Map<String, String> attrs, Configuration conf) {
        JfsFileStatus status = JfsFileStatus.createStatusInner(f, 0L, false, replication, conf);
        status.setPermission(permission);
        status.setAttrs(attrs);
        return status;
    }

    public static JfsFileStatus createStatus(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Configuration conf) {
        JfsFileStatus status = JfsFileStatus.createStatusInner(f, 0L, false, replication, conf);
        status.setPermission(permission);
        return status;
    }

    public static JfsFileStatus createStatus(Path f, String inodeId, long length, Configuration conf) {
        JfsFileStatus status = JfsFileStatus.createStatusInner(f, length, false, (short)1, conf);
        status.setINodeId(inodeId);
        return status;
    }

    public static JfsFileStatus createStatusForDir(Path f, FsPermission permission, Configuration conf) {
        JfsFileStatus status = JfsFileStatus.createStatusInner(f, 0L, true, (short)0, conf);
        status.setPermission(permission);
        return status;
    }

    private static JfsFileStatus createStatusInner(Path f, long length, boolean isDir, short replication, Configuration conf) {
        String group;
        String user;
        JfsFileStatus status = new JfsFileStatus(length, isDir, replication, conf);
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (Exception e) {
            user = "oss";
        }
        try {
            group = UserGroupInformation.getCurrentUser().getPrimaryGroupName();
        }
        catch (Exception e) {
            group = user;
        }
        status.setOwner(user);
        status.setGroup(group);
        status.setPath(f);
        return status;
    }

    public static ByteBuffer toBuffer(JfsFileStatus status) {
        int attrOffset;
        FlatBufferBuilder inodeBuilder = new FlatBufferBuilder();
        String idStr = status.getINodeId() != null ? status.getINodeId() : "";
        int idOffset = inodeBuilder.createString(idStr);
        int ownerOffset = inodeBuilder.createString(status.getOwner());
        int groupOffset = inodeBuilder.createString(status.getGroup());
        int fileNameOffset = inodeBuilder.createString("");
        int etagOffset = inodeBuilder.createString("");
        int pidOffset = inodeBuilder.createString("");
        Map<String, String> attrs = status.getAttrs();
        if (attrs != null && !attrs.isEmpty()) {
            int size = attrs.size();
            int[] xattrOffsets = new int[size];
            FlatBufferBuilder xattrBuilder = new FlatBufferBuilder();
            int i = 0;
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                int nameOffset = xattrBuilder.createString(entry.getKey());
                int valueOffset = xattrBuilder.createString(entry.getValue());
                xattrOffsets[i] = Xattribute.createXattribute(xattrBuilder, nameOffset, valueOffset, (byte)0);
                ++i;
            }
            int xattrListOffset = xattrBuilder.createVectorOfTables(xattrOffsets);
            FileletXattributeList.startFileletXattributeList(xattrBuilder);
            FileletXattributeList.addXattributes(xattrBuilder, xattrListOffset);
            xattrBuilder.finish(FileletXattributeList.endFileletXattributeList(xattrBuilder));
            attrOffset = inodeBuilder.createString(xattrBuilder.dataBuffer());
        } else {
            attrOffset = inodeBuilder.createString("");
        }
        InodeStatus.startInodeStatus(inodeBuilder);
        InodeStatus.addFileType(inodeBuilder, status.isDirectory() ? (byte)0 : 1);
        InodeStatus.addFileId(inodeBuilder, idOffset);
        InodeStatus.addFileName(inodeBuilder, fileNameOffset);
        InodeStatus.addAttributes(inodeBuilder, attrOffset);
        InodeStatus.addParentId(inodeBuilder, pidOffset);
        InodeStatus.addOwner(inodeBuilder, ownerOffset);
        InodeStatus.addOwnerGroup(inodeBuilder, groupOffset);
        InodeStatus.addFileSize(inodeBuilder, status.getLen());
        InodeStatus.addPermission(inodeBuilder, status.getPermission().toShort());
        InodeStatus.addMtime(inodeBuilder, status.getModificationTime());
        InodeStatus.addDirectChildrenLoaded(inodeBuilder, false);
        InodeStatus.addEtag(inodeBuilder, etagOffset);
        if (status.isDirectory()) {
            InodeStatus.addState(inodeBuilder, (byte)2);
        } else {
            InodeStatus.addState(inodeBuilder, (byte)1);
        }
        inodeBuilder.finish(InodeStatus.endInodeStatus(inodeBuilder));
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int inodeOff = builder.createString(inodeBuilder.dataBuffer());
        int locateOffset = builder.createString("");
        FileletStatus.startFileletStatus(builder);
        FileletStatus.addLocations(builder, locateOffset);
        FileletStatus.addInode(builder, inodeOff);
        builder.finish(FileletStatus.endFileletStatus(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    public String getINodeId() {
        return this.jindoINodeId;
    }

    public void setINodeId(String jindoINodeId) {
        this.jindoINodeId = jindoINodeId;
    }

    public void setAttrs(Map<String, String> attrs) {
        this.attrs = attrs;
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getState() {
        return this.state;
    }

    public String convertJfsStorageClass(byte storagePolicy) {
        try {
            return StoragePolicy.name(storagePolicy);
        }
        catch (Throwable e) {
            return "Unknown";
        }
    }

    public String convertJfsState(byte state) {
        try {
            return FsState.name(state);
        }
        catch (Throwable e) {
            return "Unknown";
        }
    }
}

