/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import com.alibaba.jboot.JbootJfsWriter;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.aliyun.emr.compatibility.StopWatch;
import com.aliyun.emr.fs.common.FsStats;
import com.aliyun.emr.fs.internal.jfs.JfsFileletSystem;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JfsOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(JfsOutputStream.class);
    protected boolean closed;
    protected final byte[] singleByteBuf = new byte[1];
    protected ByteBuffer buffer;
    protected long fileSize = 0L;
    protected long lastFlushPosition = 0L;
    protected long writeElapsedNanos = 0L;
    protected final WriteContext context;

    public JfsOutputStream(WriteContext context) {
        this.context = context;
        this.buffer = JbootBufferFactory.allocateBuffer(context.bufferSize);
        this.buffer.position(0);
        this.buffer.limit(0);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkStatus();
        this.singleByteBuf[0] = (byte)b;
        this.write(this.singleByteBuf, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buff, int off, int len) throws IOException {
        this.checkStatus();
        boolean flushBuffer = false;
        int nWritten = 0;
        if (len > this.buffer.remaining()) {
            nWritten = this.buffer.remaining();
            flushBuffer = true;
        } else {
            nWritten = len;
        }
        if (nWritten > 0) {
            this.fileSize += (long)nWritten;
            this.buffer.put(buff, off, nWritten);
            this.context.fileSize.addAndGet(nWritten);
        }
        if (flushBuffer) {
            this.flushBuffer();
            this.write(buff, off + nWritten, len - nWritten);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() throws IOException {
        if (!this.context.enableFlush) {
            LOG.info("Not real flush for higher write performance. If you exactly need flush, please set fs.jfs.flush.enable as true");
            return;
        }
        this.checkStatus();
        StopWatch sw = new StopWatch().start();
        try {
            if (this.fileSize == this.lastFlushPosition) {
                return;
            }
            this.flushPartialBuffer();
            this.context.jbootWriter.flushFile(this.context.timeoutInSecond);
            this.lastFlushPosition = this.fileSize;
        }
        finally {
            long duration = sw.stop().now();
            FsStats.logStats("flush", this.context.path, null, this.fileSize, null, duration, "3.7.2");
            this.writeElapsedNanos += duration;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.buffer == null) {
                LOG.warn("Write buffer has been released because of former write failure, just do some clean up");
                return;
            }
            this.flushBuffer();
            StopWatch sw = new StopWatch().start();
            this.context.jbootWriter.finalizeFile(this.context.timeoutInSecond);
            long duration = sw.stop().now();
            this.writeElapsedNanos += duration;
            FsStats.logStats("finalizeFile", this.context.path, null, this.context.fileSize.get(), null, duration, "3.7.2");
        }
        catch (IOException e) {
            LOG.error("Close stream " + this.context.path + " error " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.closed = true;
            this.cleanUp();
            FsStats.logStats("upload", this.context.path, null, this.context.fileSize.get(), null, this.writeElapsedNanos, "3.7.2");
        }
    }

    protected void flushPartialBuffer() throws IOException {
        if (this.buffer == null) {
            return;
        }
        StopWatch sw = new StopWatch().start();
        this.flipBuffer();
        try {
            if (this.buffer.remaining() > 0) {
                this.doWriteBuffer();
            }
            this.buffer.position(this.buffer.limit());
            this.buffer.limit(this.buffer.capacity());
            this.buffer.mark();
        }
        catch (Exception e) {
            this.cleanUp();
            throw new IOException("Failed to flush write buffer after some tries, path " + this.context.path + ", fid:" + this.context.iNodeId, e);
        }
        finally {
            this.writeElapsedNanos += sw.stop().now();
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.buffer == null) {
            return;
        }
        StopWatch sw = new StopWatch().start();
        this.flipBuffer();
        try {
            if (this.buffer.remaining() > 0) {
                this.doWriteBuffer();
            }
            this.buffer.clear();
        }
        catch (Exception e) {
            this.cleanUp();
            throw new IOException("Failed to flush write buffer after some tries, path " + this.context.path + ", fid:" + this.context.iNodeId, e);
        }
        finally {
            this.writeElapsedNanos += sw.stop().now();
        }
    }

    private void flipBuffer() {
        this.buffer.limit(this.buffer.position());
        try {
            this.buffer.reset();
        }
        catch (InvalidMarkException e) {
            this.buffer.position(0);
        }
    }

    private void doWriteBuffer() throws Exception {
        this.context.jbootWriter.write(this.buffer, this.context.timeoutInSecond);
    }

    protected void finalize() {
        this.cleanUp();
    }

    private void checkStatus() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream already closed.");
        }
    }

    protected void cleanUp() {
        this.context.jbootWriter.close();
        if (this.buffer != null) {
            JbootBufferFactory.returnBuffer(this.buffer);
            this.buffer = null;
        }
    }

    public static class WriteContext {
        public String iNodeId;
        public Path path;
        public int bufferSize;
        public int timeoutInSecond;
        public boolean enableDirectUpload;
        public JfsFileletSystem fileletSystem;
        public JbootJfsWriter jbootWriter;
        public boolean enableFlush;
        public AtomicLong fileSize = new AtomicLong(0L);
    }
}

