/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.oss;

import com.aliyun.emr.shade.google_guava.base.Preconditions;
import com.aliyun.emr.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OssLoginHelper {
    static final Logger LOG = LoggerFactory.getLogger(OssLoginHelper.class);
    public static final String LOGIN_WARNING = "The Filesystem URI contains login details. This authentication mechanism is no longer supported.";

    private OssLoginHelper() {
    }

    public static URI buildFSURI(URI uri) {
        OssLoginHelper.rejectSecretsInURIs(uri);
        Objects.requireNonNull(uri, "null uri");
        Objects.requireNonNull(uri.getScheme(), "null uri.getScheme()");
        if (uri.getHost() == null && uri.getAuthority() != null) {
            Objects.requireNonNull(uri.getHost(), "null uri host.");
        }
        Objects.requireNonNull(uri.getHost(), "null uri host.");
        return URI.create(uri.getScheme() + "://" + uri.getHost());
    }

    public static String toString(URI pathUri) {
        return pathUri != null ? String.format("%s://%s/%s", pathUri.getScheme(), pathUri.getHost(), pathUri.getPath()) : "(null URI)";
    }

    public static void rejectSecretsInURIs(URI name) {
        Login login = OssLoginHelper.extractLoginDetails(name);
        try {
            Preconditions.checkArgument(!login.hasLogin(), LOGIN_WARNING);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static Login extractLoginDetails(URI name) {
        if (name == null) {
            return Login.EMPTY;
        }
        String authority = name.getAuthority();
        if (authority == null) {
            return Login.EMPTY;
        }
        String accessKeyId = "";
        String accessKeySecret = "";
        String securityToken = "";
        String userInfo = name.getUserInfo();
        if (userInfo != null) {
            String[] ossCredentials = userInfo.split(":");
            if (ossCredentials.length >= 2) {
                accessKeyId = ossCredentials[0];
                accessKeySecret = ossCredentials[1];
            }
            if (ossCredentials.length == 3) {
                securityToken = ossCredentials[2];
            }
        }
        return new Login(accessKeyId, accessKeySecret, securityToken);
    }

    public static URI canonicalizeUri(URI uri, int defaultPort) {
        if (uri.getPort() == -1 && defaultPort > 0) {
            try {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), defaultPort, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)("Valid URI became unparseable: " + uri));
            }
        }
        return uri;
    }

    public static void checkPath(Configuration conf, URI fsUri, Path path, int defaultPort) {
        URI pathUri = path.toUri();
        String thatScheme = pathUri.getScheme();
        if (thatScheme == null) {
            return;
        }
        URI thisUri = OssLoginHelper.canonicalizeUri(fsUri, defaultPort);
        String thisScheme = thisUri.getScheme();
        if (StringUtils.equalsIgnoreCase(thisScheme, thatScheme)) {
            String thisHost = thisUri.getHost();
            String thatHost = pathUri.getHost();
            if (thatHost == null && thisHost != null) {
                URI defaultUri = FileSystem.getDefaultUri((Configuration)conf);
                pathUri = StringUtils.equalsIgnoreCase(thisScheme, defaultUri.getScheme()) ? defaultUri : null;
            }
            if (pathUri != null && (thisHost == (thatHost = (pathUri = OssLoginHelper.canonicalizeUri(pathUri, defaultPort)).getHost()) || thisHost != null && StringUtils.equalsIgnoreCase(thisHost, thatHost))) {
                return;
            }
        }
        throw new IllegalArgumentException("Wrong FS " + OssLoginHelper.toString(pathUri) + " -expected " + fsUri);
    }

    public static class Login {
        private final String user;
        private final String password;
        private final String token;
        public static final Login EMPTY = new Login();

        public Login() {
            this("", "", "");
        }

        public Login(String user, String password, String token) {
            this.user = user;
            this.password = password;
            this.token = token;
        }

        public boolean hasLogin() {
            return StringUtils.isNotEmpty(this.user) && StringUtils.isNotEmpty(this.password);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Login that = (Login)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && Objects.equals(this.token, that.token);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.password, this.token);
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getToken() {
            return this.token;
        }
    }
}

