/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.ossnative;

import com.alibaba.jboot.JbootOssReader;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.aliyun.emr.compatibility.StopWatch;
import com.aliyun.emr.fs.common.FsStats;
import com.aliyun.emr.fs.internal.JindoInputStream;
import com.aliyun.emr.fs.internal.ossnative.OssOpContext;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoOssInputStream
extends JindoInputStream
implements ByteBufferReadable {
    static final Logger LOG = LoggerFactory.getLogger(JindoOssInputStream.class);
    private final OssReadContext context;
    private JbootOssReader jbootReader;

    public JindoOssInputStream(OssReadContext context, JbootOssReader jbootReader) {
        super(context);
        this.context = context;
        this.jbootReader = jbootReader;
    }

    @Override
    protected int bufferMore() throws IOException {
        if (this.currentBufferId + 1L >= this.context.totalBuffers) {
            return -1;
        }
        ++this.currentBufferId;
        if (this.buffer.capacity() <= 0) {
            this.buffer = JbootBufferFactory.allocateBuffer(this.context.bufferSize);
            this.buffer.limit(0);
        }
        long length = this.context.bufferSize;
        if (this.currentBufferId == this.context.totalBuffers - 1L) {
            length = this.context.fileSize - this.currentBufferId * (long)this.context.bufferSize;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("readBuffer " + this.currentBufferId + " for " + this.context.ossCtx.key + "TID [" + this.context.tid + "]");
        }
        StopWatch sw = new StopWatch().start();
        try {
            this.jbootReader.read(this.currentBufferId * (long)this.context.bufferSize, length, this.buffer);
            this.byteReaded += (long)this.buffer.remaining();
        }
        catch (Exception e) {
            this.cleanUp();
            throw new IOException("Read from " + this.context.path + " error ", e);
        }
        this.readElapsedNanos += sw.stop().now();
        if (LOG.isDebugEnabled()) {
            LOG.debug("readBuffer " + this.currentBufferId + " for " + this.context.ossCtx.key + "TID [" + this.context.tid + "]");
        }
        return this.buffer.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromPostion(long position, byte[] buffer, int offset, int length) throws IOException {
        if (position < 0L) {
            throw new EOFException("Cannot seek to a negative offset: Pos = " + position);
        }
        StopWatch sw = new StopWatch().start();
        ByteBuffer partBuffer = JbootBufferFactory.allocateBuffer(length);
        try {
            this.jbootReader.randomRead(position, length, partBuffer, false);
            partBuffer.get(buffer, offset, length);
            int n = length;
            return n;
        }
        finally {
            FsStats.logStats("randomRead", this.context.path, null, (long)length, null, sw.stop().now(), "3.7.2");
            JbootBufferFactory.returnBuffer(partBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromPostion(long position, ByteBuffer byteBuffer, int length) throws IOException {
        if (position < 0L) {
            throw new EOFException("Cannot seek to a negative offset: Pos = " + position);
        }
        StopWatch sw = new StopWatch().start();
        ByteBuffer partBuffer = JbootBufferFactory.allocateBuffer(length);
        try {
            this.jbootReader.randomRead(position, length, partBuffer, false);
            byteBuffer.put(partBuffer);
            int n = length;
            return n;
        }
        finally {
            FsStats.logStats("randomRead", this.context.path, null, (long)length, null, sw.stop().now(), "3.7.2");
            JbootBufferFactory.returnBuffer(partBuffer);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.cleanUp();
            super.close();
        }
    }

    public void finalize() {
        this.cleanUp();
    }

    private synchronized void cleanUp() {
        this.jbootReader.close();
        if (this.buffer != null && this.buffer.capacity() > 0) {
            JbootBufferFactory.returnBuffer(this.buffer);
            this.buffer = null;
        }
    }

    public static class OssReadContext
    extends JindoInputStream.ReadContext {
        public OssOpContext ossCtx = new OssOpContext();
    }
}

