/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.ossnative;

import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.internal.ossnative.OssOpContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssGetFileChecksum2Op {
    static final Logger LOG = LoggerFactory.getLogger(OssGetFileChecksum2Op.class);
    private final OssOpContext context;
    private final FileSystem fs;
    private final CredentialContext ossContext;

    public OssGetFileChecksum2Op(OssOpContext context, FileSystem fs, CredentialContext ossContext) {
        this.context = context;
        this.fs = fs;
        this.ossContext = ossContext;
    }

    public String getFileChecksum2(Path f, CredentialContext ossContext) throws IOException {
        try {
            return this.context.ossFileletSystem.getFileChecksum2(new JindoRequestPath(f.toString(), ossContext));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

