/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.jfs.commit;

import com.aliyun.emr.fs.jfs.commit.BackupFiles;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutoFlushingConcurrentLinkedQueue
implements Closeable {
    private static final int BUFFER_SIZE_LIMIT = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(AutoFlushingConcurrentLinkedQueue.class);
    private final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue();
    private final BackupFiles files = this.getBackupFiles();
    private final int limit = this.getBufferLimit();

    AutoFlushingConcurrentLinkedQueue() {
    }

    void add(String data) throws IOException {
        this.queue.add(data);
        if (this.queue.size() >= this.limit) {
            this.flush();
        }
    }

    private synchronized void flush() throws IOException {
        int num = this.queue.size();
        if (num < this.limit) {
            return;
        }
        this.files.transfer(this.queue, num);
    }

    synchronized void foreach(BatchFunction func) throws IOException {
        long fileNum;
        this.files.flush();
        ArrayList<String> batch = new ArrayList<String>(this.queue);
        long batchNum = 0L;
        if (!batch.isEmpty()) {
            LOG.info("Applying to queue data ...");
            batchNum = BatchFunction.next(batchNum, batch, func);
        }
        if ((fileNum = this.files.getFileNum()) > 0L) {
            LOG.info("Applying to backup file data ...");
            for (long i = 0L; i < fileNum; ++i) {
                String fileName = this.files.getFileName(i);
                try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        batch.add(line);
                        if (batch.size() < this.limit) continue;
                        batchNum = BatchFunction.next(batchNum, batch, func);
                    }
                    continue;
                }
            }
            BatchFunction.next(batchNum, batch, func);
        }
    }

    boolean nonEmpty() {
        return !this.queue.isEmpty() || this.files.getFileNum() > 0L;
    }

    @VisibleForTesting
    BackupFiles getBackupFiles() {
        return new BackupFiles();
    }

    @VisibleForTesting
    int getBufferLimit() {
        return 10000;
    }

    @VisibleForTesting
    ConcurrentLinkedQueue<String> getEmbedded() {
        return this.queue;
    }

    @Override
    public synchronized void close() throws IOException {
        this.queue.clear();
        this.files.close();
    }

    static interface BatchFunction {
        public void apply(long var1, List<String> var3) throws IOException;

        public static long next(long i, List<String> batch, BatchFunction func) throws IOException {
            if (batch == null || batch.isEmpty()) {
                return i;
            }
            func.apply(i, batch);
            batch.clear();
            return i + 1L;
        }
    }
}

