/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.jfs.commit;

import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Queue;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackupFiles
implements Closeable {
    private static final long SINGLE_FILE_DATA_LIMIT = 100000000L;
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_");
    private static final String PREFIX_PATTERN = ".auto_flush_%s_%s_";
    private static final Logger LOG = LoggerFactory.getLogger(BackupFiles.class);
    private final String prefix;
    private final long limit;
    private long fileNum;
    private long currentFileData = 0L;
    private BufferedWriter writer = null;

    BackupFiles() {
        Date d = Calendar.getInstance().getTime();
        this.prefix = String.format(PREFIX_PATTERN, SIMPLE_DATE_FORMAT.format(d), UUID.randomUUID());
        this.fileNum = 0L;
        this.limit = this.getSingleFileDataLimit();
    }

    synchronized void transfer(Queue<String> queue, long n) throws IOException {
        if (queue == null || n <= 0L) {
            return;
        }
        if (this.writer == null) {
            String fileName = this.getFileName(this.fileNum);
            LOG.info("Create a new backup file {}", (Object)fileName);
            this.writer = new BufferedWriter(new FileWriter(fileName));
        }
        for (long i = 0L; i < n; ++i) {
            String data = queue.poll();
            if (data == null) continue;
            this.writer.write(data);
            this.writer.newLine();
        }
        this.currentFileData += n;
        if (this.currentFileData >= this.limit) {
            LOG.info("Rolling to a new backup file");
            this.rollingNew();
        }
    }

    private void rollingNew() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.close();
        this.writer = null;
        ++this.fileNum;
        this.currentFileData = 0L;
    }

    synchronized void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    synchronized long getFileNum() {
        return this.fileNum + (long)(this.writer == null ? 0 : 1);
    }

    String getFileName(long num) {
        return this.prefix + num;
    }

    @VisibleForTesting
    long getSingleFileDataLimit() {
        return 100000000L;
    }

    @Override
    public synchronized void close() throws IOException {
        this.rollingNew();
        while (this.fileNum > 0L) {
            String fileName;
            if (new File(fileName = this.getFileName(--this.fileNum)).delete()) continue;
            LOG.warn("Cannot delete backup file " + fileName);
        }
    }
}

