/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit.magic;

import java.io.File;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class CommitUtilsWithMR {
    private static final Logger LOG = LoggerFactory.getLogger(CommitUtilsWithMR.class);

    private CommitUtilsWithMR() {
    }

    public static Path getMagicJobAttemptsPath(Path out, String UUID2) {
        if (UUID2 == null) {
            return new Path(out, "__magic");
        }
        return new Path(out, "__magic_" + UUID2);
    }

    public static int getAppAttemptId(JobContext context) {
        return context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0);
    }

    public static Path getMagicJobAttemptPath(int appAttemptId, Path dest, String UUID2) {
        return new Path(CommitUtilsWithMR.getMagicJobAttemptsPath(dest, UUID2), CommitUtilsWithMR.formatAppAttemptDir(appAttemptId));
    }

    public static String formatAppAttemptDir(int attemptId) {
        return String.format("app-attempt-%04d", attemptId);
    }

    public static Path getMagicTaskAttemptsPath(JobContext context, Path dest, String UUID2) {
        return new Path(CommitUtilsWithMR.getMagicJobAttemptPath(CommitUtilsWithMR.getAppAttemptId(context), dest, UUID2), "tasks");
    }

    public static Path getMagicTaskAttemptPath(TaskAttemptContext context, Path dest, String UUID2) {
        return new Path(CommitUtilsWithMR.getBaseMagicTaskAttemptPath(context, dest, UUID2), "__base");
    }

    public static Path getBaseMagicTaskAttemptPath(TaskAttemptContext context, Path dest, String UUID2) {
        return new Path(CommitUtilsWithMR.getMagicTaskAttemptsPath((JobContext)context, dest, UUID2), String.valueOf(context.getTaskAttemptID()));
    }

    public static Path getTempJobAttemptPath(int appAttemptId, Path out) {
        return new Path(new Path(out, "__temp-data"), CommitUtilsWithMR.formatAppAttemptDir(appAttemptId));
    }

    public static Path getTempTaskAttemptPath(TaskAttemptContext context, Path out) {
        return new Path(CommitUtilsWithMR.getTempJobAttemptPath(CommitUtilsWithMR.getAppAttemptId((JobContext)context), out), String.valueOf(context.getTaskAttemptID()));
    }

    public static String jobIdString(JobContext context) {
        JobID jobID = context.getJobID();
        return jobID != null ? jobID.toString() : "(no job ID)";
    }

    public static String jobName(JobContext context) {
        String name = context.getJobName();
        return name != null && !name.isEmpty() ? name : "(anonymous)";
    }

    public static String getConfigurationOption(JobContext context, Configuration fsConf, String key, String defVal) {
        return context.getConfiguration().getTrimmed(key, fsConf.getTrimmed(key, defVal));
    }

    public static Path toCopyMagicPath(Path destPath, Path destDir, String UUID2, TaskAttemptContext context) {
        Path magicDir = CommitUtilsWithMR.getMagicTaskAttemptPath(context, destDir, UUID2);
        String suffix = destPath.toString().replaceFirst(destDir.toString(), "");
        if (suffix.startsWith(File.separator)) {
            suffix = suffix.substring(1);
        }
        Path result = new Path(magicDir, suffix);
        LOG.info("destPath: {}, destDir: {}, magicDir: {}, result: {}", new Object[]{destPath, destDir, magicDir, result});
        return result;
    }
}

