/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit.magic;

import bigboot.protocol.type.CltListMultiUploadReply;
import bigboot.protocol.type.UploadInfo;
import bigboot.protocol.type.UploadInfoList;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.internal.ossnative.OssFileletSystem;
import com.aliyun.emr.fs.internal.ossnative.OssPartInfo;
import com.aliyun.emr.fs.oss.commit.magic.SinglePendingCommit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssDirectClient {
    private Logger LOG = LoggerFactory.getLogger(OssDirectClient.class);
    private OssFileletSystem fileletSystem;
    private CredentialContext ossContext;

    public OssDirectClient(OssFileletSystem ossFileletSystem, CredentialContext ossContext) {
        this.fileletSystem = ossFileletSystem;
        this.ossContext = ossContext;
    }

    public void abortMultipartUpload(String destKey, String uploadId) throws IOException {
        this.LOG.debug("Aborting multipart upload {} to {}", (Object)uploadId, (Object)destKey);
        this.fileletSystem.abortUpload(new JindoRequestPath(destKey, this.ossContext), uploadId);
    }

    public long completeMultipartUpload(SinglePendingCommit commit) throws IOException {
        List<OssPartInfo> parts = commit.getPartInfoList();
        ByteBuffer partListBuffer = OssPartInfo.createPartList(parts);
        this.LOG.debug("Commit multi upload, key: {}, uploadId: {}, bucket: {}", new Object[]{commit.getDestinationKey(), commit.getUploadId(), commit.getBucket()});
        this.fileletSystem.completeUpload(new JindoRequestPath(commit.getDestinationKey(), this.ossContext), commit.getUploadId(), partListBuffer);
        return commit.getLength();
    }

    public String getChecksum(SinglePendingCommit commit) throws IOException {
        this.LOG.debug("get file checksum, key: {}, bucket: {}", (Object)commit.getDestinationKey(), (Object)commit.getBucket());
        return this.fileletSystem.getFileChecksum(new JindoRequestPath(commit.getDestinationKey(), this.ossContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, String>> listPendingUploadUnderPath(String path) {
        Table multiUploadReply = null;
        try {
            multiUploadReply = this.fileletSystem.listMultipartUpload(new JindoRequestPath(path, this.ossContext));
            UploadInfoList uploads = ((CltListMultiUploadReply)multiUploadReply).uploadListAsUploadInfoList();
            ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>(uploads.uploadsLength());
            for (int i = 0; i < uploads.uploadsLength(); ++i) {
                UploadInfo uploadInfo = uploads.uploads(i);
                this.LOG.debug("key: {}, uploadId: {}", (Object)uploadInfo.key(), (Object)uploadInfo.uploadId());
                result.add((Pair<String, String>)new Pair((Object)uploadInfo.key(), (Object)uploadInfo.uploadId()));
            }
            this.LOG.info("Found {} incomplete upload under {}", (Object)result.size(), (Object)path);
            ArrayList<Pair<String, String>> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            this.LOG.warn("Failed to list multipart uploads due to access denied, or you can manually clear uncompleted multipart uploads under " + path + " if exists. Please add 'oss:ListMultipartUploads' permission to AliyunECSInstanceForEMRRole if it is EMR cluster.");
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            return arrayList;
        }
        finally {
            if (multiUploadReply != null) {
                JbootBufferFactory.returnBuffer(multiUploadReply.getByteBuffer());
            }
        }
    }
}

