/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit.magic;

import com.aliyun.emr.fs.oss.commit.magic.CommitUtils;
import com.aliyun.emr.fs.oss.commit.magic.PersistentCommitData;
import com.aliyun.emr.fs.oss.commit.magic.ValidationFailure;
import com.aliyun.emr.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SuccessData
extends PersistentCommitData {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessData.class);
    private static final long serialVersionUID = 507133045258460084L;
    private String name = "org.apache.hadoop.fs.oss.commit.files.SuccessData/1";
    private long timestamp;
    private String date;
    private String hostname;
    private String committer;
    private String description;
    private List<String> filenames = new ArrayList<String>(0);
    private Map<String, String> diagnostics = new HashMap<String, String>();

    @Override
    public void validate() throws ValidationFailure {
    }

    @Override
    public byte[] toBytes() throws IOException {
        this.validate();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeLong(this.timestamp);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.date);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.hostname);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.committer);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.description);
            dataOutputStream.writeInt(this.filenames.size());
            for (String string : this.filenames) {
                CommitUtils.writeStringToOutputStream(dataOutputStream, string);
            }
            dataOutputStream.writeInt(this.diagnostics.size());
            for (Map.Entry entry : this.diagnostics.entrySet()) {
                CommitUtils.writeStringToOutputStream(dataOutputStream, (String)entry.getKey());
                CommitUtils.writeStringToOutputStream(dataOutputStream, (String)entry.getValue());
            }
            dataOutputStream.flush();
            Object object = outputStream.toByteArray();
            return object;
        }
        catch (IOException e) {
            LOG.error("Failed to serialize SuccessData.", (Throwable)e);
            throw e;
        }
        finally {
            try {
                dataOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close OutputStream.", (Throwable)e);
            }
        }
    }

    @Override
    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        try (FSDataOutputStream outputStream = fs.create(path, overwrite);){
            outputStream.writeChars(this.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SuccessData{");
        sb.append("committer='").append(this.committer).append('\'');
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", date='").append(this.date).append('\'');
        sb.append(", filenames=[").append(StringUtils.join(this.filenames, ", ")).append("]");
        sb.append(", diagnostics={").append(SuccessData.joinMap(this.diagnostics, "", "->", "")).append("}");
        sb.append('}');
        return sb.toString();
    }

    protected static String joinMap(Map<String, ?> map, String prefix, String middle, String suffix) {
        if (map == null) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder(list.size() * 32);
        for (String k : list) {
            sb.append(prefix).append(k).append(middle).append(map.get(k)).append(suffix);
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public void setFilenames(List<String> filenames) {
        this.filenames = filenames;
    }

    public Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(Map<String, String> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public void addDiagnostic(String key, String value) {
        this.diagnostics.put(key, value);
    }
}

