/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3;

import bigboot.protocol.type.FileletStatus;
import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.S3CredentialProviderList;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractS3TokenIdentifier;
import com.aliyun.emr.fs.s3.auth.delegation.DelegationTokenProvider;
import com.aliyun.emr.fs.s3.auth.delegation.S3DelegationTokens;
import com.aliyun.emr.fs.s3.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.s3.internal.s3native.S3FileStatus;
import com.aliyun.emr.fs.s3.internal.s3native.S3NativeStore;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.S3TrashPolicy;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoS3FileSystem
extends AbstractJindoShimsFileSystem
implements DelegationTokenProvider {
    public static final Logger LOG = LoggerFactory.getLogger(JindoS3FileSystem.class);
    private Optional<S3DelegationTokens> delegationTokens = Optional.empty();
    private UserGroupInformation owner;
    private S3CredentialProviderList credentialsProviders = null;
    private String defaultStorageClass = null;

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        if (!(uri.getScheme().equals("s3") || uri.getScheme().equals("s3a") || uri.getScheme().equals("s3n"))) {
            throw new IOException("Wrong scheme: JindoS3FileSystem only support s3 scheme, please check your configuration files.");
        }
        String bucket = uri.getHost();
        LOG.debug("Initializing JindoS3FileSystem for {}", (Object)bucket);
        Configuration updateConf = AuthUtils.propagateBucketOptions(conf, bucket);
        updateConf = AuthUtils.propagateDeprecatedS3Options(updateConf);
        AuthUtils.patchSecurityCredentialProviders(updateConf);
        super.initialize(uri, conf);
        this.setConf(updateConf);
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
        this.owner = UserGroupInformation.getCurrentUser();
        boolean dtEnabled = S3DelegationTokens.hasDelegationTokenBinding(conf);
        if (dtEnabled) {
            LOG.debug("Using delegation tokens");
            S3DelegationTokens tokens = new S3DelegationTokens();
            this.delegationTokens = Optional.of(tokens);
            tokens.bindToFileSystem(this.getCanonicalUri(), this.owner);
            tokens.init(this.getConf());
            tokens.start();
            if (tokens.isBoundToDT()) {
                LOG.debug("Using existing delegation token");
            } else {
                LOG.debug("No delegation token for this instance");
            }
            this.credentialsProviders = tokens.getCredentialProviders();
        }
        this.defaultStorageClass = conf.get("fs.jfs.cache.storage-class-default", "");
        S3NativeStore.Context context = this.initNativeStoreContext();
        this.store = new S3NativeStore((FileSystem)this, this.getConf(), context);
    }

    private S3NativeStore.Context initNativeStoreContext() {
        S3NativeStore.Context context = new S3NativeStore.Context();
        context.logName = this.logName;
        context.uri = this.uri;
        context.workingDir = this.workingDir;
        context.statistics = this.statistics;
        context.credentialProviders = this.credentialsProviders;
        String host = this.uri.getHost();
        if (!StringUtils.isEmpty(host) && !host.contains(".")) {
            context.prefix = host;
        } else if (!StringUtils.isEmpty(host)) {
            context.prefix = host.substring(0, host.indexOf("."));
        }
        return context;
    }

    @Override
    protected FSDataOutputStream createCore(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.store.create(f, permission, overwrite, bufferSize, replication, blockSize, progress, this.defaultStorageClass);
    }

    @Override
    protected boolean deleteCore(Path f, boolean recurse, boolean deleteVersion) throws IOException {
        return this.store.delete(f, recurse, false, deleteVersion);
    }

    @Override
    protected FileStatus getFileStatusCore(Path f) throws IOException {
        return this.store.getFileStatus(f);
    }

    @Override
    protected FileStatus[] listStatusCore(Path f) throws IOException {
        return this.store.listStatus(f, false, false);
    }

    @Override
    protected boolean mkdirsCore(Path f, FsPermission permission) throws IOException {
        return this.store.mkdirs(f, permission);
    }

    @Override
    protected FSDataInputStream openCore(Path f, int bufferSize) throws IOException {
        return this.store.open(f, bufferSize);
    }

    @Override
    protected boolean renameCore(Path src, Path dst) throws IOException {
        return this.store.rename(src, dst, false, false);
    }

    @Override
    protected BlockLocation[] getFileBlockLocationsCore(FileStatus file, long start, long len) throws IOException {
        return this.store.getFileBlockLocations(file, start, len);
    }

    @Override
    protected byte[] getXAttrCore(Path path, String name) throws IOException {
        return this.store.getXAttr(path, name);
    }

    @Override
    protected Map<String, byte[]> getXAttrsCore(Path path) throws IOException {
        return this.store.getXAttrs(path);
    }

    @Override
    protected Map<String, byte[]> getXAttrsCore(Path path, List<String> names) throws IOException {
        return this.store.getXAttrs(path, names);
    }

    @Override
    protected void setXAttrCore(Path path, String name, byte[] value) throws IOException {
        this.store.setXAttr(path, name, value);
    }

    @Override
    protected List<String> listXAttrsCore(Path path) throws IOException {
        return this.store.listXAttrs(path);
    }

    @Override
    protected void removeXAttrCore(Path path, String name) throws IOException {
        this.store.removeXAttr(path, name);
    }

    @Override
    protected void checkPermissionCore(Path path, FsAction mode) throws IOException {
        this.store.checkPermission(path, mode);
    }

    @Override
    protected ContentSummary getContentSummaryCore(Path path) throws IOException {
        return this.store.getContentSummary(path);
    }

    @Override
    public boolean renameFilesCore(Path srcFolder, Path destFolder, boolean errorOnExists) throws IOException {
        return this.store.rename(srcFolder, destFolder, !errorOnExists, true);
    }

    @Override
    public boolean moveToAppropriateTrashCore(Path p) throws IOException {
        Path fullyResolvedPath = p;
        FileSystem fullyResolvedFs = FileSystem.get((URI)fullyResolvedPath.toUri(), (Configuration)this.conf);
        Configuration confCopy = new Configuration(this.conf);
        confCopy.set("fs.trash.classname", S3TrashPolicy.class.getName());
        Trash trash = new Trash(fullyResolvedFs, confCopy);
        return trash.moveToTrash(fullyResolvedPath);
    }

    @Override
    public boolean deleteFilesCore(Path p) throws IOException {
        return this.store.delete(p, true, true, false);
    }

    public FSDataOutputStream create(Path f, String storageOption) throws IOException {
        return this.store.create(f, FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)this.getConf())), true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(f), this.getDefaultBlockSize(f), null, storageOption);
    }

    public FSDataOutputStream create(Path f, String storageOption, String checksumInfo) throws IOException {
        return this.store.create(f, FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)this.getConf())), true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(f), this.getDefaultBlockSize(f), null, storageOption, checksumInfo);
    }

    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("FileSystem [ " + this.getUri() + " ] closed");
        }
        super.close();
    }

    @Override
    public String getScheme() {
        return "s3";
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return -1;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    @Override
    public Boolean isCacheMode() {
        return true;
    }

    @Override
    public Boolean isMagicCommitEnabled() {
        return this.store.isMagicCommitEnabled();
    }

    @Override
    protected void unCacheCore(Path path) throws IOException {
        this.store.uncache(path);
    }

    @Override
    protected void cacheCore(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        this.store.cache(path, opContext);
    }

    @Override
    protected FileletStatus[] checkProgressCore(Path path, boolean detailed) throws IOException {
        return this.store.checkProgress(path, detailed);
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    public URI getCanonicalUri() {
        return this.uri;
    }

    public String getCanonicalServiceName() {
        if (!this.delegationTokens.isPresent()) {
            return null;
        }
        S3DelegationTokens dt = this.delegationTokens.get();
        return dt.getTokenIssuingPolicy() != S3DelegationTokens.TokenIssuingPolicy.NoTokensAvailable ? dt.getCanonicalServiceName() : null;
    }

    @VisibleForTesting
    public Optional<S3DelegationTokens> getDelegationTokens() {
        return this.delegationTokens;
    }

    public Token<AbstractS3TokenIdentifier> getDelegationToken(String renewer) throws IOException {
        LOG.debug("Delegation token requested");
        if (this.delegationTokens.isPresent()) {
            return this.delegationTokens.get().getBoundOrNewDT(renewer != null ? new Text(renewer) : new Text());
        }
        LOG.debug("Token support is not enabled");
        return null;
    }

    @Override
    public Token<? extends TokenIdentifier> getFsDelegationToken() throws IOException {
        return this.getDelegationToken(null);
    }

    public S3FileStatus getS3FileStatus(Path f) throws IOException {
        if (this.store instanceof S3NativeStore) {
            S3NativeStore s3Store = (S3NativeStore)this.store;
            return s3Store.getS3FileStatus(f);
        }
        throw new IOException("Internal Error");
    }
}

