/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.CredentialInitializationException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public abstract class AbstractSessionCredentialsProvider
implements S3CredentialsProvider {
    private final URI binding;
    private final Configuration conf;
    private final S3CredentialsProvider.CredentialType type;
    private S3Credentials credentials;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private IOException initializationException;

    public AbstractSessionCredentialsProvider(@Nullable URI uri, Configuration conf, S3CredentialsProvider.CredentialType type) {
        this.conf = conf;
        this.binding = uri;
        this.type = type;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void refresh() {
    }

    public URI getUri() {
        return this.binding;
    }

    public S3CredentialsProvider.CredentialType getType() {
        return this.type;
    }

    protected void init() throws IOException {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        try {
            this.credentials = this.createCredentials(this.getConf());
        }
        catch (IOException e) {
            this.initializationException = e;
            throw e;
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    protected abstract S3Credentials createCredentials(Configuration var1) throws IOException;

    @Override
    public S3Credentials getCredentials() throws CredentialInitializationException {
        try {
            if (!this.isInitialized()) {
                this.init();
            }
        }
        catch (IOException e) {
            throw new CredentialInitializationException(e.getMessage(), e);
        }
        if (this.credentials == null) {
            throw new CredentialInitializationException("Provider " + this + " has no credentials");
        }
        return this.credentials;
    }

    public final boolean hasCredentials() {
        return this.credentials == null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @VisibleForTesting
    public IOException getInitializationException() {
        return this.initializationException;
    }
}

