/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.BasicCredentials;
import com.aliyun.emr.fs.s3.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.s3.auth.NoCredentialsException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;

public class JindoCommonCredentialsProvider
implements S3CredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.s3.auth.JindoCommonCredentialsProvider";
    private final Configuration conf;

    public JindoCommonCredentialsProvider(@Nullable URI uri, Configuration conf, S3CredentialsProvider.CredentialType type) {
        this.conf = conf;
    }

    @Override
    public S3Credentials getCredentials() {
        try {
            String accessKeyId = AuthUtils.getPassword(this.conf, "jindo.common.accessKeyId", null, "");
            String accessKeySecret = AuthUtils.getPassword(this.conf, "jindo.common.accessKeySecret", null, "");
            String securityToken = AuthUtils.getPassword(this.conf, "jindo.common.securityToken", null, "");
            if (!StringUtils.isEmpty(accessKeyId) && !StringUtils.isEmpty(accessKeySecret)) {
                if (!StringUtils.isEmpty(securityToken)) {
                    return new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken);
                }
                return new BasicCredentials(accessKeyId, accessKeySecret);
            }
        }
        catch (IOException e) {
            throw new NoCredentialsException("JindoCommonCredentialsProvider", "Fail to get common credentials in the configuration");
        }
        throw new NoCredentialsException("JindoCommonCredentialsProvider", "Fail to get common credentials in the configuration");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

